/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.packet;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.PenguinPacket;
import joshie.harvest.player.PlayerTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Packet
public class PacketQuestIncrease
extends PenguinPacket {
    private Quest quest;
    private NBTTagCompound tag;

    public PacketQuestIncrease() {
    }

    public PacketQuestIncrease(Quest quest) {
        this.quest = quest;
    }

    public PacketQuestIncrease(Quest quest, NBTTagCompound tag) {
        this.quest = quest;
        this.tag = tag;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.quest.getRegistryName().toString());
        buf.writeBoolean(this.tag != null);
        if (this.tag != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.quest = (Quest)Quest.REGISTRY.getValue(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        if (buf.readBoolean()) {
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        Quest real = ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getQuests().getAQuest(this.quest);
        if (real != null) {
            if (!player.field_70170_p.field_72995_K) {
                int previous = real.quest_stage++;
                real.onStageChanged(player, previous, real.quest_stage);
                PacketHandler.sendToClient(new PacketQuestIncrease(real, real.writeToNBT(new NBTTagCompound())), player);
            } else {
                real.readFromNBT(this.tag);
            }
        }
    }
}

