/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PenguinPacket;
import joshie.harvest.quests.data.QuestData;
import joshie.harvest.town.data.TownData;
import joshie.harvest.town.tracker.TownTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Packet(value=Packet.Side.CLIENT)
public class PacketQuest<Q extends QuestData>
extends PenguinPacket {
    protected UUID uuid;

    public PacketQuest setUUID(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.uuid != null);
        if (this.uuid != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid.toString());
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.uuid = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public Q getQuestDataFromPlayer(EntityPlayer player) {
        if (this.uuid == null) {
            return (Q)HFTrackers.getPlayerTrackerFromPlayer(player).getQuests();
        }
        return ((TownData)((TownTracker)HFTrackers.getTownTracker(player.field_70170_p)).getTownByID(this.uuid)).getQuests();
    }
}

