/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.api.quests.QuestType;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.helpers.SerializeHelper;
import joshie.harvest.core.util.interfaces.IQuestMaster;
import joshie.harvest.quests.data.QuestData;
import joshie.harvest.quests.packet.PacketQuest;
import joshie.harvest.quests.packet.PacketQuestCompleted;
import joshie.harvest.quests.packet.PacketQuestConnect;
import joshie.harvest.quests.packet.PacketQuestSetCurrent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class QuestDataServer
extends QuestData {
    private final IQuestMaster master;
    private Map<Quest, CalendarDate> lastFinished = new HashMap<Quest, CalendarDate>();

    public QuestDataServer(IQuestMaster master) {
        this.master = master;
    }

    public CalendarDate getLastCompletionOfQuest(Quest quest) {
        return this.lastFinished.get((Object)quest);
    }

    @Override
    public boolean startQuest(Quest q, boolean sync) {
        try {
            if (!this.finished.contains((Object)q) || q.isRepeatable()) {
                Quest quest = ((Quest)((Quest)((Object)((Object)((Object)q)).getClass().newInstance())).setRegistryName(q.getRegistryName())).setStage(0);
                this.current.add(quest);
                if (sync) {
                    this.master.sync(null, (PacketQuest)((Object)new PacketQuestSetCurrent(quest)));
                }
                return true;
            }
            return false;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void finish(EntityPlayer player, Quest quest, boolean rewards) {
        this.finished.add(quest);
        if (rewards) {
            quest.onQuestCompleted(player);
        }
        if (quest.isRepeatable() && quest.getDaysBetween() > 0) {
            this.lastFinished.put(quest, HFApi.calendar.getDate(player.field_70170_p).copy());
        }
    }

    @Override
    public void markCompleted(EntityPlayer player, Quest quest, boolean rewards) {
        Quest localQuest = this.getAQuest(quest);
        if (localQuest != null) {
            this.current.remove((Object)localQuest);
            this.finish(player, localQuest, rewards);
        } else {
            this.finish(player, quest, rewards);
        }
        HFTrackers.markDirty(player.field_70170_p);
        if (quest.getQuestType() == QuestType.PLAYER || quest.getQuestType() == QuestType.TOWN && rewards) {
            this.master.sync(player, (PacketQuest)((Object)new PacketQuestCompleted(quest, rewards)));
        }
        if (quest.getQuestType() == QuestType.TOWN) {
            this.master.sync(null, (PacketQuest)((Object)new PacketQuestCompleted(quest, false)));
        }
        this.updateQuests(true);
    }

    public void updateQuests(boolean sync) {
        for (Quest quest : Quest.REGISTRY.getValues()) {
            this.updateQuests(quest, sync);
        }
    }

    public void sync(@Nullable EntityPlayerMP player) {
        this.updateQuests(false);
        this.master.sync((EntityPlayer)player, (PacketQuest)new PacketQuestConnect(this.writeToNBT(new NBTTagCompound())));
    }

    private void updateQuests(Quest quest, boolean sync) {
        if (quest.getQuestType() != this.master.getQuestType()) {
            return;
        }
        if ((!this.finished.contains((Object)quest) || quest.isRepeatable()) && !this.current.contains((Object)quest) && this.canStart(quest, this.current, this.finished)) {
            this.startQuest(quest, sync);
        }
    }

    private boolean canStart(Quest quest, Set<Quest> active, Set<Quest> finished) {
        Set npcs = quest.getNPCs();
        if (npcs != null) {
            for (Quest a : active) {
                if (!a.isRealQuest()) continue;
                for (INPC npc : npcs) {
                    for (INPC n : a.getNPCs()) {
                        if (!n.equals(npc)) continue;
                        return false;
                    }
                }
            }
        }
        return quest.canStartQuest(active, finished);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.lastFinished = SerializeHelper.readMap(Quest.class, CalendarDate.class, "LastQuest", nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        SerializeHelper.writeMap(this.lastFinished, "LastQuest", nbt);
        return super.writeToNBT(nbt);
    }
}

