/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.data;

import joshie.harvest.api.quests.Quest;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.quests.data.QuestData;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class QuestDataClient
extends QuestData {
    public void addAsCurrent(Quest quest) {
        this.current.add(quest);
    }

    @Override
    public void markCompleted(EntityPlayer player, Quest quest, boolean rewards) {
        Quest aQuest = this.getAQuest(quest);
        if (aQuest != null && rewards) {
            aQuest.onQuestCompleted(player);
        }
        this.current.remove((Object)quest);
        this.finished.add(quest);
    }

    private String getScript(Quest quest, EntityPlayer player, EntityNPC entity) {
        return quest.getLocalizedScript(player, (EntityLiving)entity, entity.getNPC());
    }

    public String getScript(EntityPlayer player, EntityNPC npc) {
        for (Quest q : this.current) {
            String script;
            if (!q.getNPCs().contains(npc.getNPC()) || (script = this.getScript(q, player, npc)) == null) continue;
            return script;
        }
        return null;
    }
}

