/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.data;

import java.util.HashSet;
import java.util.Set;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.npc.entity.EntityNPC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;

public abstract class QuestData {
    protected final Set<Quest> current = new HashSet<Quest>();
    protected final Set<Quest> finished = new HashSet<Quest>();

    public Set<Quest> getCurrent() {
        return this.current;
    }

    public Set<Quest> getFinished() {
        return this.finished;
    }

    public Quest getSelection(EntityPlayer player, EntityNPC npc) {
        for (Quest q : this.current) {
            if (!q.getNPCs().contains(npc.getNPC()) || q.getSelection(player, npc.getNPC()) == null) continue;
            return q;
        }
        return null;
    }

    public Quest getAQuest(Quest quest) {
        if (!quest.isRealQuest() && !this.current.contains((Object)quest)) {
            this.startQuest(quest, false);
        }
        for (Quest q : this.current) {
            if (!q.equals((Object)quest)) continue;
            return q;
        }
        return null;
    }

    public abstract void markCompleted(EntityPlayer var1, Quest var2, boolean var3);

    public boolean startQuest(Quest quest, boolean sync) {
        return false;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        NBTTagList list;
        if (nbt.func_74764_b("CurrentQuests")) {
            list = nbt.func_150295_c("CurrentQuests", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                Quest q = (Quest)Quest.REGISTRY.getValue(new ResourceLocation(tag.func_74779_i("QuestID")));
                if (q == null) continue;
                try {
                    Quest quest = (Quest)((Quest)((Object)((Object)((Object)q)).getClass().newInstance())).setRegistryName(q.getRegistryName());
                    quest.readFromNBT(tag);
                    this.current.add(quest);
                    continue;
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        if (nbt.func_74764_b("FinishedQuests")) {
            list = nbt.func_150295_c("FinishedQuests", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.finished.add((Quest)Quest.REGISTRY.getValue(new ResourceLocation(list.func_150307_f(i))));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList quests = new NBTTagList();
        for (Quest s : this.current) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("QuestID", s.getRegistryName().toString());
            s.writeToNBT(tag);
            quests.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("CurrentQuests", (NBTBase)quests);
        NBTTagList done = new NBTTagList();
        for (Quest s : this.finished) {
            if (s == null) continue;
            done.func_74742_a((NBTBase)new NBTTagString(s.getRegistryName().toString()));
        }
        nbt.func_74782_a("FinishedQuests", (NBTBase)done);
        return nbt;
    }
}

