/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests;

import java.util.HashSet;
import java.util.Set;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.quests.IQuestHelper;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.api.quests.QuestQuestion;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.helpers.SpawnItemHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.HFApiImplementation;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.quests.packet.PacketQuestCompleteEarly;
import joshie.harvest.quests.packet.PacketQuestIncrease;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

@HFApiImplementation
public class QuestHelper
implements IQuestHelper {
    public static final QuestHelper INSTANCE = new QuestHelper();
    private static final Set<Quest> EMPTY = new HashSet<Quest>();

    private QuestHelper() {
    }

    @Override
    public void completeQuest(Quest quest, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getQuests().markCompleted(quest);
        }
    }

    @Override
    public void completeEarly(QuestQuestion quest, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.sendToClient(new PacketQuestCompleteEarly(quest), player);
        }
    }

    @Override
    public void increaseStage(Quest quest, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            int previous = quest.quest_stage++;
            quest.onStageChanged(player, previous, quest.quest_stage);
            PacketHandler.sendToClient(new PacketQuestIncrease(quest, quest.writeToNBT(new NBTTagCompound())), player);
        }
    }

    @Override
    public void takeHeldStack(EntityPlayer player, int amount) {
        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, amount);
    }

    @Override
    public void rewardItem(Quest quest, EntityPlayer player, ItemStack stack) {
        SpawnItemHelper.addToPlayerInventory(player, stack);
    }

    @Override
    public void rewardGold(EntityPlayer player, long amount) {
        if (!player.field_70170_p.field_72995_K) {
            ((PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().addGold((EntityPlayerMP)player, amount);
        }
    }

    @Override
    public void rewardEntity(Quest quest, EntityPlayer player, String entity) {
        Entity theEntity;
        if (!player.field_70170_p.field_72995_K && (theEntity = EntityList.func_188429_b((String)entity, (World)player.field_70170_p)) != null) {
            theEntity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            if (theEntity instanceof IAnimalTracked) {
                ((IAnimalTracked)theEntity).getData().setOwner(EntityHelper.getPlayerUUID(player));
            }
            player.field_70170_p.func_72838_d(theEntity);
        }
    }

    private boolean isFakePlayer(EntityPlayer player) {
        return player instanceof FakePlayer;
    }

    @Override
    public Set<Quest> getCurrentQuests(EntityPlayer player) {
        if (this.isFakePlayer(player)) {
            return EMPTY;
        }
        return new HashSet<Quest>(((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getQuests().getCurrent());
    }

    public static void markAvailable(EntityPlayer player, Quest quest) {
        ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getQuests().setAvailable(quest);
    }

    public static void markAsCurrent(EntityPlayer player, Quest quest) {
        ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getQuests().addAsCurrent(quest);
    }

    public static void startQuest(EntityPlayer player, Quest quest) {
        ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getQuests().startQuest(quest);
    }

    public static Quest getQuest(String name) {
        try {
            return (Quest)Quest.REGISTRY.getValue(new ResourceLocation("harvestfestival", name));
        }
        catch (Exception e) {
            return null;
        }
    }
}

