/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quest.IQuest;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.quests.PacketQuestSetStage;
import joshie.harvest.core.util.Translate;
import joshie.harvest.npc.entity.EntityNPC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Quest
implements IQuest {
    protected String name;
    protected int quest_stage;
    protected Set<IQuest> required;

    @Override
    public IQuest setStage(int quest_stage) {
        this.quest_stage = quest_stage;
        return this;
    }

    @Override
    public int getStage() {
        return this.quest_stage;
    }

    @Override
    public IQuest setUniqueName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getUniqueName() {
        return this.name;
    }

    protected void increaseStage(EntityPlayer player) {
        int previous = this.quest_stage++;
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.sendToClient(new PacketQuestSetStage(this, this.quest_stage), (EntityPlayer)((EntityPlayerMP)player));
        } else {
            PacketHandler.sendToServer(new PacketQuestSetStage(this, this.quest_stage));
        }
        this.onStageChanged(player, previous, this.quest_stage);
    }

    protected boolean isRepeatable() {
        return false;
    }

    public int getOptions() {
        return 0;
    }

    public void onSelected(EntityPlayer player, int option) {
    }

    @Override
    public boolean canStart(EntityPlayer player, HashSet<IQuest> active, HashSet<IQuest> finished) {
        if (finished.contains(this) && !this.isRepeatable()) {
            return false;
        }
        if (this.required != null && !finished.containsAll(this.required)) {
            return false;
        }
        for (IQuest a : active) {
            for (INPC npc : this.getNPCs()) {
                if (!a.handlesScript(npc)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract INPC[] getNPCs();

    protected String getLocalized(String quest) {
        return Translate.translate("quest." + this.name + "." + quest.replace("_", ""));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handlesScript(INPC npc) {
        for (INPC n : this.getNPCs()) {
            if (!n.equals(npc)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getScript(EntityPlayer player, INPC npc) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getScript(EntityPlayer player, EntityNPC npc) {
        String script = this.getScript(player, npc.getNPC());
        return script == null ? null : this.getLocalized(script);
    }

    @Override
    public void claim(EntityPlayer player) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.quest_stage = nbt.func_74765_d("Completed");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74777_a("Completed", (short)this.quest_stage);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.quest_stage);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.quest_stage = buf.readShort();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof IQuest)) {
            return false;
        }
        return this.name.equals(((IQuest)o).getUniqueName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void onEntityInteract(EntityPlayer player, Entity target) {
    }

    @Override
    public void onClosedChat(EntityPlayer player, EntityNPC npc) {
    }

    @Override
    public void onRightClickBlock(EntityPlayer player, BlockPos pos, EnumFacing face) {
    }

    public void select(EntityPlayer player, EntityNPC npc, int option) {
    }

    @Override
    public void confirm(EntityPlayer player, EntityNPC npc) {
    }

    @Override
    public void cancel(EntityPlayer player, EntityNPC npc) {
    }

    @Override
    public void onStageChanged(EntityPlayer player, int previous, int stage) {
    }
}

