/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.plugins.crafttweaker.handler;

import java.util.Locale;
import javax.annotation.Nullable;
import joshie.harvest.api.calendar.Weekday;
import joshie.harvest.api.npc.IGreeting;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCRegistry;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.item.ItemNPCTool;
import joshie.harvest.plugins.crafttweaker.CraftTweaker;
import joshie.harvest.plugins.crafttweaker.base.BaseOnce;
import joshie.harvest.plugins.crafttweaker.base.BaseUndoable;
import joshie.harvest.plugins.crafttweaker.wrapper.GreetingWrapper;
import joshie.harvest.plugins.crafttweaker.wrapper.PurchasableWrapper;
import joshie.harvest.plugins.crafttweaker.wrapper.PurchasableWrapperCarpenter;
import joshie.harvest.shops.HFShops;
import joshie.harvest.shops.Shop;
import joshie.harvest.shops.ShopRegistry;
import joshie.harvest.shops.purchasable.Purchasable;
import joshie.harvest.shops.purchasable.PurchasableBuilder;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.harvestfestival.Shops")
public class Shops {
    @ZenMethod
    public static void addShopToNPC(String npc, String shop, String greeting, String openinghours, @Optional String hoursText) {
        NPC theNPC = (NPC)NPCRegistry.REGISTRY.getValue(new ResourceLocation("harvestfestival", npc));
        if (theNPC == null) {
            CraftTweaker.logError(String.format("No NPC with the id %s could be found. Use /hf npcs for a list of ids", npc));
        } else if (theNPC.getShop() != null) {
            CraftTweaker.logError(String.format("Attempted to add a shop to %s when they already have a shop", theNPC.getLocalizedName()));
        } else if (ShopRegistry.INSTANCE.shops.containsKey(new ResourceLocation("MineTweaker3", shop.toLowerCase()))) {
            CraftTweaker.logError(String.format("Attempted to add a shop with a duplicate id: %s", "MineTweaker3:" + shop.toLowerCase()));
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddShop(theNPC, shop, greeting, openinghours, hoursText));
        }
    }

    @ZenMethod
    public static void addPurchasable(String shop, IItemStack sellable, long cost) {
        Shop theShop = ShopRegistry.INSTANCE.getShop(new ResourceLocation(shop));
        if (theShop == null) {
            CraftTweaker.logError(String.format("No shop with the id %s could be found. Use /hf shops for a list of ids", shop));
        }
        MineTweakerAPI.apply((IUndoableAction)new AddPurchasable(theShop, BaseOnce.asStack((IIngredient)sellable), cost));
    }

    @ZenMethod
    public static void addPurchasableToBuilder(IItemStack sellable, int wood, int stone, long cost) {
        MineTweakerAPI.apply((IUndoableAction)new AddBuilderPurchasable(BaseOnce.asStack((IIngredient)sellable), wood, stone, cost));
    }

    @ZenMethod
    public static void removePurchasable(String shop, String id) {
        Shop theShop = ShopRegistry.INSTANCE.getShop(new ResourceLocation(shop));
        if (theShop == null) {
            CraftTweaker.logError(String.format("No shop with the id %s could be found. Use /hf shops for a list of ids", shop));
        } else if (theShop.getPurchasableFromID(id) == null) {
            CraftTweaker.logError(String.format("No purchasable with the id %s could be found in " + theShop.getLocalizedName(), id));
        } else {
            MineTweakerAPI.apply((IUndoableAction)new RemovePurchasable(theShop, theShop.getPurchasableFromID(id)));
        }
    }

    @ZenMethod
    public static void adjustPurchasable(String shop, String id, long cost) {
        Shop theShop = ShopRegistry.INSTANCE.getShop(new ResourceLocation(shop));
        if (theShop == null) {
            CraftTweaker.logError(String.format("No shop with the id %s could be found. Use /hf shoplist for a list of ids", shop));
        } else if (theShop.getPurchasableFromID(id) == null) {
            CraftTweaker.logError(String.format("No purchasable with the id %s could be found in " + theShop.getLocalizedName(), id));
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AdjustPurchasable(theShop, theShop.getPurchasableFromID(id), cost));
        }
    }

    @ZenMethod
    @Deprecated
    public static void adjustCarpenter(String id, int logs, int stone, long cost) {
        Shop shop = (Shop)HFShops.CARPENTER;
        if (shop.getPurchasableFromID(id) == null) {
            CraftTweaker.logError(String.format("No purchasable with the id %s could be found in " + HFShops.CARPENTER, id));
        } else if (!(shop.getPurchasableFromID(id) instanceof PurchasableBuilder)) {
            CraftTweaker.logError(String.format("The item %s did not originaly accept materials, you cannot adjust the values", id));
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AdjustCarpenter((PurchasableBuilder)shop.getPurchasableFromID(id), cost, logs, stone));
        }
    }

    private static class AdjustCarpenter
    extends AdjustPurchasable {
        protected final int wood;
        protected final int stone;
        protected PurchasableBuilder purchasable;
        PurchasableWrapperCarpenter wrapper;

        AdjustCarpenter(PurchasableBuilder purchasable, long cost, int wood, int stone) {
            super((Shop)HFShops.CARPENTER, purchasable, cost);
            this.purchasable = purchasable;
            this.wood = wood;
            this.stone = stone;
        }

        @Override
        public void apply() {
            this.shop.removeItem(this.purchasable);
            this.wrapper = new PurchasableWrapperCarpenter(this.purchasable, this.wood, this.stone, this.cost);
            this.shop.addItem(this.wrapper);
        }
    }

    private static class AdjustPurchasable
    extends BaseUndoable {
        protected final Shop shop;
        protected final IPurchasable purchasable;
        protected final long cost;
        IPurchasable wrapper;

        AdjustPurchasable(Shop shop, IPurchasable purchasable, long cost) {
            this.shop = shop;
            this.purchasable = purchasable;
            this.cost = cost;
        }

        @Override
        public String getDescription() {
            return "Adjusting value of  " + this.purchasable.getDisplayStack().func_82833_r();
        }

        public void apply() {
            this.shop.removeItem(this.purchasable);
            this.wrapper = new PurchasableWrapper(this.purchasable, this.cost);
            this.shop.addItem(this.wrapper);
        }

        @Override
        public boolean canUndo() {
            return this.wrapper != null;
        }

        public void undo() {
            this.shop.removeItem(this.wrapper);
            this.shop.addItem(this.purchasable);
        }
    }

    private static class RemovePurchasable
    extends BaseUndoable {
        protected final Shop shop;
        protected final IPurchasable purchasable;

        RemovePurchasable(Shop shop, IPurchasable purchasable) {
            this.shop = shop;
            this.purchasable = purchasable;
        }

        @Override
        public String getDescription() {
            return "Removing " + this.purchasable.getDisplayStack().func_82833_r() + " from " + this.shop.getLocalizedName();
        }

        public void apply() {
            this.shop.removeItem(this.purchasable);
        }

        public void undo() {
            this.shop.addItem(this.purchasable);
        }
    }

    private static class AddBuilderPurchasable
    extends AddPurchasable {
        protected final int stone;
        protected final int wood;

        AddBuilderPurchasable(ItemStack stack, int stone, int wood, long cost) {
            super((Shop)HFShops.CARPENTER, stack, cost);
            this.stone = stone;
            this.wood = wood;
        }

        @Override
        public String getDescription() {
            return "Adding " + this.stack.func_82833_r() + " to the Carpenter's shop.";
        }

        @Override
        public void apply() {
            this.purchasable = new PurchasableBuilder(this.cost, this.stone, this.wood, this.stack);
            this.shop.addItem(this.purchasable);
        }
    }

    private static class AddPurchasable
    extends BaseUndoable {
        protected final Shop shop;
        protected final ItemStack stack;
        protected final long cost;
        protected IPurchasable purchasable;

        AddPurchasable(Shop shop, ItemStack stack, long cost) {
            this.shop = shop;
            this.stack = stack;
            this.cost = cost;
        }

        @Override
        public String getDescription() {
            return "Adding " + this.stack.func_82833_r() + " to " + this.shop.getLocalizedName();
        }

        public void apply() {
            this.purchasable = new Purchasable(this.cost, this.stack);
            this.shop.addItem(this.purchasable);
        }

        @Override
        public boolean canUndo() {
            return this.purchasable != null;
        }

        public void undo() {
            this.shop.removeItem(this.purchasable);
        }
    }

    private static class AddShop
    extends BaseUndoable {
        private final ResourceLocation resource;
        private final String name;
        private final NPC npc;
        private final String greeting;
        private final String openinghours;
        private IGreeting hours;
        private Shop shop;

        AddShop(NPC npc, String shop, String greeting, String openinghours, @Nullable String hoursText) {
            this.resource = new ResourceLocation("MineTweaker3", shop.toLowerCase());
            this.name = shop;
            this.npc = npc;
            this.greeting = greeting;
            this.openinghours = openinghours;
            if (hoursText != null) {
                this.hours = new GreetingWrapper(hoursText);
            }
        }

        @Override
        public String getDescription() {
            return "Created the shop " + this.name;
        }

        private void processTimeString(String time) {
            String[] split = time.split(",");
            if (split.length == 3) {
                Weekday day = Weekday.valueOf(split[0].toUpperCase(Locale.ENGLISH));
                int start = Integer.parseInt(split[1]);
                int end = Integer.parseInt(split[2]);
                this.shop.addOpening(day, start, end);
            }
        }

        public void apply() {
            String[] hours;
            this.shop = new Shop(this.resource){

                @Override
                public String getLocalizedName() {
                    return name;
                }

                @Override
                public String getWelcome(EntityPlayer player, EntityNPC npc) {
                    return greeting;
                }
            };
            this.npc.setShop(this.shop);
            this.npc.setHasInfo(null, null);
            if (this.hours != null) {
                this.npc.setHasInfo(HFNPCs.TOOLS.getStackFromEnum(ItemNPCTool.NPCTool.CLOCK), this.hours);
            }
            ShopRegistry.INSTANCE.shops.put(this.resource, this.shop);
            for (String time : hours = this.openinghours.replace(" ", "").split(";")) {
                this.processTimeString(time);
            }
        }

        @Override
        public boolean canUndo() {
            return this.shop != null;
        }

        public void undo() {
            this.npc.setShop(null);
            this.npc.setHasInfo(null, null);
            ShopRegistry.INSTANCE.shops.remove(this.resource);
        }
    }
}

