/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.plugins.crafttweaker.handler;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.Ore;
import joshie.harvest.plugins.crafttweaker.base.BaseOnce;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.harvestfestival.Shipping")
public class Shipping {
    @ZenMethod
    public static void addShipping(IIngredient ingredient, long sellValue) {
        if (ingredient instanceof IItemStack || ingredient instanceof IOreDictEntry) {
            MineTweakerAPI.apply((IUndoableAction)new Add(ingredient, sellValue));
        }
    }

    private static class Add
    extends BaseOnce {
        private final long sellValue;
        private ItemStack stack;
        private Ore ore;

        public Add(IIngredient ingredient, long sellValue) {
            this.sellValue = sellValue;
            this.stack = Add.asStack(ingredient);
            this.ore = Ore.of(Add.asOre(ingredient));
        }

        @Override
        public String getDescription() {
            return "Added " + this.stack.func_82833_r() + " as shippable";
        }

        @Override
        public void applyOnce() {
            if (this.stack != null) {
                HFApi.shipping.registerSellable(this.stack, this.sellValue);
            }
            if (this.ore != null) {
                HFApi.shipping.registerSellable(this.ore, this.sellValue);
            }
        }
    }
}

