/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.plugins.buttons;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.api.calendar.Weather;
import joshie.harvest.calendar.CalendarServer;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.plugins.buttons.Buttons;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tehnut.buttons.api.WidgetTexture;
import tehnut.buttons.api.button.utility.ButtonMode;
import tehnut.buttons.api.button.utility.IMode;

public class ButtonWeather
extends ButtonMode<WeatherModes> {
    private final String name;

    public ButtonWeather() {
        super(Buttons.BLANK, WeatherModes.class);
        this.name = "button_weather";
        this.setServerRequired();
    }

    public boolean requireElevatedPermissions() {
        return this.isServerRequired();
    }

    public ResourceLocation getButtonId() {
        return new ResourceLocation("buttons", this.name);
    }

    public static enum WeatherModes implements IMode
    {
        SUNNY(0, Weather.SUNNY),
        RAINY(20, Weather.RAIN),
        SNOWY(40, Weather.SNOW),
        TYPHOON(60, Weather.TYPHOON),
        BLIZZARD(80, Weather.BLIZZARD);

        private final WidgetTexture widgetTexture;
        private final Weather weather;

        private WeatherModes(int x, Weather weather) {
            this.widgetTexture = new WidgetTexture(Buttons.RESOURCE, x, 40, 20, 20);
            this.weather = weather;
        }

        @Nonnull
        public WidgetTexture getModeTexture() {
            return this.widgetTexture;
        }

        @Nullable
        public List<? extends ITextComponent> getTooltip() {
            return Collections.singletonList(new TextComponentTranslation("harvestfestival.weather." + this.weather.name().toLowerCase(Locale.ENGLISH) + ".set", new Object[0]));
        }

        @SideOnly(value=Side.CLIENT)
        public EnumActionResult onClientClick(int mouseX, int mouseY) {
            return EnumActionResult.SUCCESS;
        }

        public void onServerClick(EntityPlayerMP player) {
            ((CalendarServer)HFTrackers.getCalendar(player.field_70170_p)).setTodaysWeather(this.weather);
        }
    }
}

