/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.plugins.buttons;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.calendar.CalendarServer;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.plugins.buttons.Buttons;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tehnut.buttons.api.WidgetTexture;
import tehnut.buttons.api.button.utility.ButtonMode;
import tehnut.buttons.api.button.utility.IMode;

public class ButtonSeason
extends ButtonMode<HFSeason> {
    public ButtonSeason() {
        super(Buttons.BLANK, HFSeason.class);
        this.setServerRequired();
    }

    public ResourceLocation getButtonId() {
        return new ResourceLocation("harvestfestival", "seasons");
    }

    public static enum HFSeason implements IMode
    {
        SPRING(0, Season.SPRING),
        SUMMER(20, Season.SUMMER),
        AUTUMN(40, Season.AUTUMN),
        WINTER(60, Season.WINTER);

        private final WidgetTexture widgetTexture;
        private final Season season;

        private HFSeason(int x, Season season) {
            this.widgetTexture = new WidgetTexture(Buttons.RESOURCE, x, 20, 20, 20);
            this.season = season;
        }

        @Nonnull
        public WidgetTexture getModeTexture() {
            return this.widgetTexture;
        }

        @Nullable
        public List<? extends ITextComponent> getTooltip() {
            return Collections.singletonList(new TextComponentTranslation("harvestfestival.season." + this.season.name().toLowerCase(Locale.ENGLISH), new Object[0]));
        }

        @SideOnly(value=Side.CLIENT)
        public EnumActionResult onClientClick(int mouseX, int mouseY) {
            return EnumActionResult.SUCCESS;
        }

        public void onServerClick(EntityPlayerMP player) {
            World world = player.field_70170_p;
            CalendarServer calendar = (CalendarServer)HFTrackers.getCalendar(world);
            int day = calendar.getDate().getDay();
            int year = Math.max(1, calendar.getDate().getYear());
            long leftover = player.field_70170_p.func_72820_D() % HFCalendar.TICKS_PER_DAY;
            world.func_72877_b(CalendarHelper.getTime(day, this.season, year) + leftover);
            calendar.recalculateAndUpdate(world);
        }
    }
}

