/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.plugins;

import java.io.File;
import java.util.ArrayList;
import joshie.harvest.HarvestFestival;
import joshie.harvest.core.helpers.generic.ConfigHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;

public class HFPlugins {
    public static ArrayList<Plugin> plugins = new ArrayList();
    private static ArrayList<PluginData> data = new ArrayList();
    public static boolean AGRICRAFT_LOADED = false;
    public static boolean THAUMCRAFT_LOADED = false;

    private static Plugin get(PluginData p) {
        try {
            Plugin plugin = p.clazz.newInstance();
            plugin.modid = p.name;
            plugins.add(plugin);
        }
        catch (Exception e) {
            HarvestFestival.LOGGER.log(Level.INFO, "Failed to load plugin for modid: " + p.name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfigs() {
        Configuration config = new Configuration(new File(HarvestFestival.root, "/plugins.cfg"));
        for (PluginData p : data) {
            if (!Loader.isModLoaded((String)p.name)) continue;
            try {
                Plugin plugin;
                config.load();
                ConfigHelper.setConfig(config);
                if (!config.get("Enabled", p.name, true).getBoolean(true) || (plugin = HFPlugins.get(p)) == null) continue;
                ConfigHelper.setCategory(p.name);
                plugin.loadConfig(config);
            }
            catch (Exception e) {
                HarvestFestival.LOGGER.log(Level.ERROR, "Harvest Festival failed to load in it's " + p.name + " config");
                e.printStackTrace();
            }
            finally {
                config.save();
            }
        }
        data = null;
    }

    public static void preInit() {
        for (Plugin plugin : plugins) {
            try {
                plugin.preInit();
            }
            catch (Exception e) {
                HarvestFestival.LOGGER.log(Level.INFO, "Failed to load plugin for modid @ PreINIT: " + plugin.modid);
                e.printStackTrace();
            }
        }
    }

    public static void init() {
        for (Plugin plugin : plugins) {
            try {
                plugin.init();
            }
            catch (Exception e) {
                HarvestFestival.LOGGER.log(Level.INFO, "Failed to load plugin for modid @ INIT: " + plugin.modid);
                e.printStackTrace();
            }
        }
    }

    public static void postInit() {
        for (Plugin plugin : plugins) {
            try {
                plugin.postInit();
            }
            catch (Exception e) {
                HarvestFestival.LOGGER.log(Level.INFO, "Failed to load plugin for modid @ PostINIT: " + plugin.modid);
                e.printStackTrace();
            }
        }
        plugins = null;
    }

    private static class PluginData {
        String name;
        Class<? extends Plugin> clazz;

        public PluginData(String name, Class<? extends Plugin> clazz) {
            this.name = name;
            this.clazz = clazz;
        }
    }

    public static abstract class Plugin {
        public String modid;

        public void loadConfig(Configuration config) {
        }

        public void preInit() {
        }

        public void init() {
        }

        public void postInit() {
        }
    }
}

