/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.tracking;

import java.util.HashSet;
import java.util.Iterator;
import joshie.harvest.api.HFApi;
import joshie.harvest.cooking.recipe.MealImpl;
import joshie.harvest.core.achievements.HFAchievements;
import joshie.harvest.core.helpers.CollectionHelper;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.holder.ItemStackHolder;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.player.packet.PacketSyncObtained;
import joshie.harvest.player.packet.PacketSyncObtainedSet;
import joshie.harvest.player.packet.PacketSyncRecipes;
import joshie.harvest.player.tracking.StackSold;
import joshie.harvest.player.tracking.Tracking;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;

public class TrackingServer
extends Tracking {
    private HashSet<StackSold> toBeShipped = new HashSet();
    public final PlayerTrackerServer master;

    public TrackingServer(PlayerTrackerServer master) {
        this.master = master;
    }

    @Override
    public boolean learnRecipe(MealImpl recipe) {
        if (super.learnRecipe(recipe)) {
            if (this.recipes.size() >= 50 && this.master.getAndCreatePlayer() != null) {
                this.master.getAndCreatePlayer().func_71029_a((StatBase)HFAchievements.recipes);
            }
            return true;
        }
        return false;
    }

    public void sync(EntityPlayerMP player) {
        PacketHandler.sendToClient(new PacketSyncObtainedSet(this.obtained), (EntityPlayer)player);
        PacketHandler.sendToClient(new PacketSyncRecipes(this.recipes), (EntityPlayer)player);
    }

    @Override
    public void addAsObtained(ItemStack stack) {
        this.obtained.add(ItemStackHolder.of(stack));
        PacketHandler.sendToClient(new PacketSyncObtained(stack), (EntityPlayer)this.master.getAndCreatePlayer());
    }

    public boolean addForShipping(ItemStack item) {
        long sell = HFApi.shipping.getSellValue(item);
        StackSold stack = StackSold.of(item, sell);
        CollectionHelper.mergeCollection(stack, this.toBeShipped);
        return sell >= 0L;
    }

    public long newDay() {
        long sold = 0L;
        Iterator<StackSold> forSale = this.toBeShipped.iterator();
        while (forSale.hasNext()) {
            StackSold stack = forSale.next();
            sold += stack.getSellValue();
            forSale.remove();
        }
        return sold;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.obtained = NBTHelper.readHashSet(ItemStackHolder.class, nbt.func_150295_c("ItemsObtained", 10));
        this.toBeShipped = NBTHelper.readHashSet(StackSold.class, nbt.func_150295_c("ToBeShipped", 10));
        this.recipes = NBTHelper.readResourceSet(nbt, "Recipes");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("ItemsObtained", (NBTBase)NBTHelper.writeCollection(this.obtained));
        nbt.func_74782_a("ToBeShipped", (NBTBase)NBTHelper.writeCollection(this.toBeShipped));
        nbt.func_74782_a("Recipes", (NBTBase)NBTHelper.writeResourceSet(this.recipes));
        return nbt;
    }
}

