/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.tracking;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.crops.ICropData;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.util.SafeStack;
import joshie.harvest.core.util.SellStack;
import joshie.harvest.crops.CropData;
import joshie.harvest.player.tracking.TrackingData;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TrackingDataServer
extends TrackingData {
    private ArrayList<SellStack> toBeShipped = new ArrayList();

    public void sync(EntityPlayerMP player) {
    }

    public void onHarvested(ICropData data) {
        this.cropTracker.put(data, this.cropTracker.get(data) != null ? (Integer)this.cropTracker.get(data) + 1 : 0);
        HFTrackers.markDirty();
    }

    private void addSold(SellStack stack) {
        if (this.sellTracker.contains(stack)) {
            for (SellStack safe : this.sellTracker) {
                if (!safe.equals(stack)) continue;
                safe.add(stack.sell);
            }
        } else {
            this.sellTracker.add(stack);
        }
        HFTrackers.markDirty();
    }

    public boolean addForShipping(ItemStack stack) {
        long sell = HFApi.SHIPPING.getSellValue(stack);
        SellStack check = new SellStack(stack, sell);
        if (this.toBeShipped.contains(check)) {
            for (SellStack safe : this.toBeShipped) {
                if (!safe.equals(check)) continue;
                safe.add(sell);
            }
        } else {
            this.toBeShipped.add(check);
        }
        HFTrackers.markDirty();
        return sell >= 0L;
    }

    public long newDay() {
        long sold = 0L;
        Iterator<SellStack> forSale = this.toBeShipped.iterator();
        while (forSale.hasNext()) {
            SellStack stack = forSale.next();
            sold += stack.sell;
            this.addSold(stack);
            forSale.remove();
        }
        return sold;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList crops = nbt.func_150295_c("CropsHarvested", 10);
        for (int i = 0; i < crops.func_74745_c(); ++i) {
            NBTTagCompound tag = crops.func_150305_b(i);
            CropData data = new CropData();
            data.readFromNBT(tag);
            int amount = nbt.func_74762_e("Amount");
            this.cropTracker.put(data, amount);
        }
        NBTTagList sold = nbt.func_150295_c("ItemsSold", 10);
        for (int i = 0; i < sold.func_74745_c(); ++i) {
            NBTTagCompound tag = sold.func_150305_b(i);
            String name = tag.func_74779_i("ItemName");
            short damage = tag.func_74765_d("ItemDamage");
            long sell = tag.func_74763_f("SellValue");
            int amount = tag.func_74762_e("Amount");
            this.sellTracker.add(new SellStack(name, damage, amount, sell));
        }
        NBTTagList obtainedList = nbt.func_150295_c("ItemsObtained", 10);
        for (int i = 0; i < obtainedList.func_74745_c(); ++i) {
            NBTTagCompound tag = obtainedList.func_150305_b(i);
            String name = tag.func_74779_i("ItemName");
            short damage = tag.func_74765_d("ItemDamage");
            this.obtained.add(new SafeStack(name, damage));
        }
        NBTTagList shipped = nbt.func_150295_c("ToBeShipped", 10);
        for (int i = 0; i < shipped.func_74745_c(); ++i) {
            NBTTagCompound tag = shipped.func_150305_b(i);
            String name = tag.func_74779_i("ItemName");
            short damage = tag.func_74765_d("ItemDamage");
            long sell = tag.func_74762_e("SellValue");
            int amount = tag.func_74762_e("Amount");
            this.toBeShipped.add(new SellStack(name, damage, amount, sell));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList crops = new NBTTagList();
        for (Map.Entry entry : this.cropTracker.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            ((ICropData)entry.getKey()).writeToNBT(tag);
            tag.func_74768_a("Amount", ((Integer)entry.getValue()).intValue());
            crops.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("CropsHarvested", (NBTBase)crops);
        NBTTagList sold = new NBTTagList();
        for (Object stack : this.sellTracker) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ItemName", ((SellStack)stack).item);
            tag.func_74777_a("ItemDamage", (short)((SellStack)stack).damage);
            tag.func_74772_a("SellValue", ((SellStack)stack).sell);
            tag.func_74768_a("Amount", ((SellStack)stack).amount);
            sold.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ItemsSold", (NBTBase)sold);
        NBTTagList nBTTagList = new NBTTagList();
        for (SafeStack stack : this.obtained) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ItemName", stack.item);
            tag.func_74777_a("ItemDamage", (short)stack.damage);
            nBTTagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ItemsObtained", (NBTBase)nBTTagList);
        NBTTagList shipped = new NBTTagList();
        for (SellStack stack : this.toBeShipped) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ItemName", stack.item);
            tag.func_74777_a("ItemDamage", (short)stack.damage);
            tag.func_74772_a("SellValue", stack.sell);
            tag.func_74768_a("Amount", stack.amount);
            shipped.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ToBeShipped", (NBTBase)shipped);
    }
}

