/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.tracking;

import joshie.harvest.core.util.holder.AbstractDataHolder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class StackSold
extends AbstractDataHolder<StackSold> {
    private final Item item;
    private final int meta;
    private int amount;
    private long sell;

    private StackSold(Item item, int meta, int amount, long sell) {
        this.item = item;
        this.meta = meta;
        this.amount = amount;
        this.sell = sell;
    }

    public static StackSold of(ItemStack stack, long sell) {
        return new StackSold(stack.func_77973_b(), stack.func_77952_i(), stack.field_77994_a, sell);
    }

    public long getSellValue() {
        return this.sell;
    }

    @Override
    public void merge(StackSold stack) {
        this.amount += stack.amount;
        this.sell += stack.sell;
    }

    public static StackSold readFromNBT(NBTTagCompound tag) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("ItemName")));
        int meta = tag.func_74762_e("ItemMeta");
        int amount = tag.func_74762_e("SellAmount");
        long sell = tag.func_74763_f("SellValue");
        return new StackSold(item, meta, amount, sell);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("ItemName", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item)).toString());
        tag.func_74768_a("ItemMeta", this.meta);
        tag.func_74768_a("SellAmount", this.amount);
        tag.func_74772_a("SellValue", this.sell);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackSold that = (StackSold)o;
        if (this.meta != that.meta) {
            return false;
        }
        return this.item != null ? this.item.equals(that.item) : that.item == null;
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + this.meta;
        return result;
    }
}

