/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.tracking;

import joshie.harvest.api.crops.Crop;
import joshie.harvest.core.util.holder.AbstractDataHolder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class CropHarvested
extends AbstractDataHolder<CropHarvested> {
    private final Crop crop;
    private int amount;

    private CropHarvested(Crop crop, int amount) {
        this.crop = crop;
        this.amount = amount;
    }

    public static CropHarvested of(Crop crop) {
        return new CropHarvested(crop, 1);
    }

    @Override
    public void merge(CropHarvested stack) {
        this.amount += stack.amount;
    }

    public static CropHarvested readFromNBT(NBTTagCompound tag) {
        Crop crop = (Crop)Crop.REGISTRY.getValue(new ResourceLocation(tag.func_74779_i("CropResource")));
        int amount = tag.func_74762_e("SellAmount");
        return new CropHarvested(crop, amount);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.crop != null) {
            tag.func_74778_a("CropResource", this.crop.getRegistryName().toString());
            tag.func_74768_a("SellAmount", this.amount);
        }
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CropHarvested that = (CropHarvested)o;
        return this.crop != null ? this.crop.equals(that.crop) : that.crop == null;
    }

    public int hashCode() {
        return this.crop != null ? this.crop.hashCode() : 0;
    }
}

