/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.town;

import joshie.harvest.buildings.BuildingStage;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.entities.PlaceableNPC;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class TownBuilding
extends BuildingStage {
    public int dimension;

    public TownBuilding() {
    }

    public TownBuilding(BuildingStage building, int dimensionId) {
        this.building = building.building;
        this.direction = building.direction;
        this.dimension = dimensionId;
        this.pos = building.pos;
    }

    public BlockPos getRealCoordinatesFor(Placeable placeable) {
        return placeable.getTransformedPosition(this.pos, this.direction);
    }

    public BlockPos getRealCoordinatesFor(String npc_location) {
        PlaceableNPC offsets = this.building.getProvider().getNPCOffset(npc_location);
        if (offsets == null) {
            return null;
        }
        return this.getRealCoordinatesFor(offsets);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.dimension = nbt.func_74762_e("Dimension");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("Dimension", this.dimension);
    }
}

