/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.town;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import joshie.harvest.player.town.GatheringLocation;
import joshie.harvest.player.town.TownBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GatheringData {
    private Set<GatheringLocation> locations = new HashSet<GatheringLocation>();

    public ItemStack getRandomBlock() {
        return new ItemStack(Blocks.field_150343_Z, 1, 0);
    }

    public void newDay(Collection<TownBuilding> buildings) {
        WorldServer world;
        HashSet<GatheringLocation> previous = new HashSet<GatheringLocation>(this.locations);
        this.locations = new HashSet<GatheringLocation>();
        for (GatheringLocation location : previous) {
            world = DimensionManager.getWorld((int)location.dimension);
            IBlockState state = world.func_180495_p(location.position);
            if (state.func_177230_c() != location.block || state.func_177230_c().func_176201_c(state) != location.meta) continue;
            world.func_175698_g(location.position);
        }
        for (TownBuilding building : buildings) {
            world = DimensionManager.getWorld((int)building.dimension);
            int placed = 0;
            for (int i = 0; i < 64 && placed < 10; ++i) {
                BlockPos pos = building.pos.func_177982_a(32 - world.field_73012_v.nextInt(64), 4 - world.field_73012_v.nextInt(8), 32 - world.field_73012_v.nextInt(64));
                if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150349_c || !world.func_175623_d(pos.func_177984_a())) continue;
                ItemStack random = this.getRandomBlock();
                Block block = Block.func_149634_a((Item)random.func_77973_b());
                int meta = random.func_77952_i();
                if (!world.func_180501_a(pos.func_177984_a(), block.func_176203_a(meta), 2)) continue;
                this.locations.add(new GatheringLocation(block, meta, building.dimension, pos.func_177984_a()));
                ++placed;
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("GatheringLocations", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            GatheringLocation location = new GatheringLocation();
            location.readFromNBT(tag);
            this.locations.add(location);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (GatheringLocation location : this.locations) {
            NBTTagCompound tag = new NBTTagCompound();
            location.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("GatheringLocations", (NBTBase)list);
    }
}

