/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.stats;

import javax.annotation.Nullable;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.player.packet.PacketSyncBirthday;
import joshie.harvest.player.packet.PacketSyncGold;
import joshie.harvest.player.stats.Stats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatsServer
extends Stats {
    private boolean isBirthdaySet() {
        return this.birthday.getSeason() != Season.WINTER && this.birthday.getDay() != 0 && this.birthday.getYear() != 0;
    }

    public boolean setBirthday(World world) {
        if (!this.isBirthdaySet()) {
            this.birthday = HFApi.calendar.getDate(world).copy();
            return true;
        }
        return false;
    }

    public void addGold(@Nullable EntityPlayerMP player, long gold) {
        long newAmount = this.gold + gold;
        this.setGold(player, newAmount);
    }

    public void setGold(@Nullable EntityPlayerMP player, long amount) {
        this.gold = amount;
        if (player != null) {
            this.syncGold(player);
        }
    }

    public void sync(EntityPlayerMP player) {
        this.syncBirthday(player);
        this.syncGold(player);
    }

    private void syncBirthday(EntityPlayerMP player) {
        PacketHandler.sendToClient(new PacketSyncBirthday(this.getBirthday()), (EntityPlayer)player);
    }

    private void syncGold(EntityPlayerMP player) {
        PacketHandler.sendToClient(new PacketSyncGold(this.getGold()), (EntityPlayer)player);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.birthday = CalendarDate.fromNBT(nbt.func_74775_l("Birthday"));
        this.gold = nbt.func_74763_f("Gold");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Birthday", (NBTBase)this.birthday.toNBT());
        nbt.func_74772_a("Gold", this.gold);
        return nbt;
    }
}

