/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.stats;

import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.PacketSyncBirthday;
import joshie.harvest.core.network.PacketSyncGold;
import joshie.harvest.core.network.PacketSyncStats;
import joshie.harvest.player.stats.StatData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class StatDataServer
extends StatData {
    public void addGold(EntityPlayerMP player, long gold) {
        long newAmount = this.gold + gold;
        this.setGold(player, newAmount);
    }

    public void setGold(EntityPlayerMP player, long amount) {
        this.gold = amount;
        HFTrackers.markDirty();
        this.syncGold(player);
    }

    public void sync(EntityPlayerMP player) {
        this.syncBirthday(player);
        this.syncGold(player);
        this.syncStats(player);
    }

    private void syncBirthday(EntityPlayerMP player) {
        PacketHandler.sendToClient(new PacketSyncBirthday(this.getBirthday()), (EntityPlayer)player);
    }

    private void syncGold(EntityPlayerMP player) {
        PacketHandler.sendToClient(new PacketSyncGold(this.getGold()), (EntityPlayer)player);
    }

    private void syncStats(EntityPlayerMP player) {
        PacketHandler.sendToClient(new PacketSyncStats(this.getStamina(), this.getFatigue(), this.getStaminaMax(), this.getFatigueMin()), (EntityPlayer)player);
    }

    public void newDay(long bedtime, long gold) {
        long hours = 23999L - (bedtime - 6000L);
        double fatigueChange = 0.0;
        double staminaChange = 0.0;
        if (hours < 100L) {
            fatigueChange = -20.0;
        } else {
            fatigueChange = 2L + hours / 1000L * 2L;
            staminaChange = hours / 100L + 34L;
        }
        this.affectStats(staminaChange, fatigueChange);
        this.gold += gold;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.birthday.readFromNBT(nbt);
        this.stamina = nbt.func_74769_h("Stamina");
        this.fatigue = nbt.func_74769_h("Fatigue");
        this.gold = nbt.func_74763_f("Gold");
        this.staminaMax = nbt.func_74769_h("StaminaMax");
        this.fatigueMin = nbt.func_74769_h("FatigueMin");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.birthday.writeToNBT(nbt);
        nbt.func_74780_a("Stamina", this.stamina);
        nbt.func_74780_a("Fatigue", this.fatigue);
        nbt.func_74772_a("Gold", this.gold);
        nbt.func_74780_a("StaminaMax", this.staminaMax);
        nbt.func_74780_a("FatigueMin", this.fatigueMin);
    }
}

