/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.stats;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.ICalendarDate;
import joshie.harvest.core.handlers.HFTrackers;

public class StatData {
    protected ICalendarDate birthday = HFApi.CALENDAR.newDate(0, null, 0);
    protected double staminaMax = 100.0;
    protected double fatigueMin = 0.0;
    protected double stamina = 100.0;
    protected double fatigue = 0.0;
    protected long gold;

    public ICalendarDate getBirthday() {
        return this.birthday;
    }

    public void affectStats(double stamina, double fatigue) {
        this.stamina += stamina;
        this.fatigue += fatigue;
        if (this.stamina >= this.staminaMax) {
            this.stamina = this.staminaMax;
        }
        if (this.fatigue <= this.fatigueMin) {
            this.fatigue = this.fatigueMin;
        }
        HFTrackers.markDirty();
    }

    public boolean isBirthdaySet() {
        return this.birthday.getSeason() != null && this.birthday.getDay() != 0 && this.birthday.getYear() != 0;
    }

    public boolean setBirthday() {
        if (!this.isBirthdaySet()) {
            this.birthday = HFApi.CALENDAR.cloneDate(HFApi.CALENDAR.getToday());
            HFTrackers.markDirty();
            return true;
        }
        return false;
    }

    public void setBirthday(ICalendarDate newDate) {
        this.birthday = newDate;
    }

    public void setStats(double stamina, double fatigue, double staminaMax, double fatigueMin) {
        this.stamina = stamina;
        this.fatigue = fatigue;
        this.staminaMax = staminaMax;
        this.fatigueMin = fatigueMin;
    }

    public long getGold() {
        return this.gold;
    }

    public double getStamina() {
        return this.stamina;
    }

    public double getFatigue() {
        return this.fatigue;
    }

    public double getStaminaMax() {
        return this.staminaMax;
    }

    public double getFatigueMin() {
        return this.fatigueMin;
    }
}

