/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.relationships;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import joshie.harvest.api.relations.IRelatable;
import joshie.harvest.api.relations.IRelatableDataHandler;
import joshie.harvest.core.helpers.UUIDHelper;
import joshie.harvest.core.helpers.generic.EntityHelper;
import joshie.harvest.core.helpers.generic.MCClientHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;

public class RelationshipHandlerEntity
implements IRelatableDataHandler {
    private int id;

    @Override
    public String name() {
        return "entity";
    }

    @Override
    public IRelatableDataHandler copy() {
        return new RelationshipHandlerEntity();
    }

    @Override
    public void toBytes(IRelatable relatable, ByteBuf buf) {
        this.id = ((Entity)relatable).func_145782_y();
        buf.writeInt(this.id);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
    }

    @Override
    public IRelatable onMessage(boolean particles) {
        Entity entity = MCClientHelper.getWorld().func_73045_a(this.id);
        if (entity != null) {
            if (particles) {
                int j = 0;
                while ((double)j < 3.0) {
                    double d7 = entity.field_70163_u - 0.5 + (double)entity.field_70170_p.field_73012_v.nextFloat();
                    double d8 = entity.field_70165_t - 0.5 + (double)entity.field_70170_p.field_73012_v.nextFloat();
                    double d9 = entity.field_70161_v - 0.5 + (double)entity.field_70170_p.field_73012_v.nextFloat();
                    entity.field_70170_p.func_175688_a(EnumParticleTypes.HEART, d8, 1.0 + d7 - 0.125, d9, 0.0, 0.0, 0.0, new int[0]);
                    ++j;
                }
            }
            return (IRelatable)entity;
        }
        return null;
    }

    @Override
    public IRelatable readFromNBT(NBTTagCompound tag) {
        UUID uuid = UUID.fromString(tag.func_74779_i("UUID"));
        int dimension = tag.func_74762_e("Dimension");
        return (IRelatable)EntityHelper.getAnimalFromUUID(dimension, uuid);
    }

    @Override
    public void writeToNBT(IRelatable relatable, NBTTagCompound tag) {
        EntityAnimal animal = (EntityAnimal)relatable;
        tag.func_74778_a("UUID", UUIDHelper.getEntityUUID((Entity)animal).toString());
        tag.func_74768_a("Dimension", animal.field_70170_p.field_73011_w.getDimension());
    }
}

