/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.relationships;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import joshie.harvest.core.achievements.HFAchievements;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.player.packet.PacketSyncGifted;
import joshie.harvest.player.packet.PacketSyncMarriage;
import joshie.harvest.player.packet.PacketSyncRelationship;
import joshie.harvest.player.relationships.RelationshipData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;

public class RelationshipDataServer
extends RelationshipData {
    private Set<UUID> talked = new HashSet<UUID>();
    private Set<UUID> temp;

    public void newDay() {
        this.talked = new HashSet<UUID>();
        this.temp = this.gifted;
        this.gifted = new HashSet();
    }

    @Override
    public void talkTo(EntityPlayer player, UUID key) {
        if (!this.talked.contains(key)) {
            this.affectRelationship(player, key, 100);
            this.talked.add(key);
        }
    }

    @Override
    public boolean gift(EntityPlayer player, UUID key, int amount) {
        if (!this.gifted.contains(key)) {
            if (amount == 0) {
                return true;
            }
            this.syncGifted((EntityPlayerMP)player, key, true);
            this.affectRelationship(player, key, amount);
            this.gifted.add(key);
            return true;
        }
        return false;
    }

    @Override
    public void affectRelationship(EntityPlayer player, UUID key, int amount) {
        int newValue = Math.max(0, Math.min(HFNPCs.MARRIAGE_REQUIREMENT, this.getRelationship(key) + amount));
        this.relationships.put(key, newValue);
        if (newValue >= 5000) {
            player.func_71029_a((StatBase)HFAchievements.friend);
        }
        this.syncRelationship((EntityPlayerMP)player, key, newValue, true);
    }

    @Override
    public void copyRelationship(@Nullable EntityPlayer player, int adult, UUID baby, double percentage) {
        int newValue = (int)((double)adult * (percentage / 100.0));
        this.relationships.put(baby, newValue);
        if (player != null) {
            this.syncRelationship((EntityPlayerMP)player, baby, newValue, true);
        }
    }

    public void sync(EntityPlayerMP player) {
        for (UUID key : this.marriedTo) {
            this.syncMarriage(player, key, true);
        }
        for (UUID key : this.relationships.keySet()) {
            this.syncRelationship(player, key, (Integer)this.relationships.get(key), false);
        }
        if (this.temp == null) {
            for (UUID key : this.gifted) {
                this.syncGifted(player, key, true);
            }
        } else {
            for (UUID key : this.temp) {
                this.syncGifted(player, key, false);
            }
            this.temp = null;
        }
    }

    public void syncMarriage(EntityPlayerMP player, UUID key, boolean divorce) {
        PacketHandler.sendToClient(new PacketSyncMarriage(key, divorce), (EntityPlayer)player);
    }

    public void syncRelationship(EntityPlayerMP player, UUID key, int value, boolean particles) {
        PacketHandler.sendToClient(new PacketSyncRelationship(key, value, particles), (EntityPlayer)player);
    }

    public void syncGifted(EntityPlayerMP player, UUID key, boolean value) {
        PacketHandler.sendToClient(new PacketSyncGifted(key, value), (EntityPlayer)player);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList relationList = nbt.func_150295_c("Relationships", 10);
        for (int i = 0; i < relationList.func_74745_c(); ++i) {
            NBTTagCompound tag = relationList.func_150305_b(i);
            if (!tag.func_74764_b("UUID")) continue;
            UUID key = UUID.fromString(tag.func_74779_i("UUID"));
            int value = tag.func_74762_e("Value");
            this.relationships.put(key, value);
        }
        this.talked = NBTHelper.readUUIDSet(nbt, "TalkedTo");
        this.gifted = NBTHelper.readUUIDSet(nbt, "Gifted");
        this.marriedTo = NBTHelper.readUUIDSet(nbt, "MarriedTo");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList relationList = new NBTTagList();
        for (Map.Entry entry : this.relationships.entrySet()) {
            if (entry == null || entry.getKey() == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("UUID", ((UUID)entry.getKey()).toString());
            tag.func_74768_a("Value", ((Integer)entry.getValue()).intValue());
            relationList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Relationships", (NBTBase)relationList);
        nbt.func_74782_a("TalkedTo", (NBTBase)NBTHelper.writeUUIDSet(this.talked));
        nbt.func_74782_a("Gifted", (NBTBase)NBTHelper.writeUUIDSet(this.gifted));
        nbt.func_74782_a("MarriedTo", (NBTBase)NBTHelper.writeUUIDSet(this.marriedTo));
        return nbt;
    }
}

