/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.relationships;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import joshie.harvest.core.achievements.HFAchievements;
import joshie.harvest.core.util.Text;
import joshie.harvest.npc.HFNPCs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;

public abstract class RelationshipData {
    protected final HashMap<UUID, Integer> relationships = new HashMap();
    protected Set<UUID> marriedTo = new HashSet<UUID>();
    protected Set<UUID> gifted = new HashSet<UUID>();

    public void talkTo(EntityPlayer player, UUID key) {
    }

    public boolean gift(EntityPlayer player, UUID key, int amount) {
        return false;
    }

    public void affectRelationship(EntityPlayer player, UUID key, int amount) {
    }

    public void copyRelationship(@Nullable EntityPlayer player, int adult, UUID baby, double percentage) {
    }

    public void setRelationship(UUID key, int value) {
    }

    public void setMarriageState(UUID key, boolean divorce) {
    }

    public void clear(UUID key) {
        this.relationships.remove(key);
    }

    public int getRelationship(UUID key) {
        if (this.relationships.containsKey(key)) {
            return this.relationships.get(key);
        }
        this.relationships.put(key, 0);
        return 0;
    }

    public boolean propose(EntityPlayer player, UUID key) {
        if (!this.marriedTo.contains(key)) {
            int value = this.getRelationship(key);
            if (value >= HFNPCs.MARRIAGE_REQUIREMENT) {
                this.marriedTo.add(key);
                player.func_71029_a((StatBase)HFAchievements.marriage);
                this.affectRelationship(player, key, 1000);
                return true;
            }
            this.affectRelationship(player, key, -500);
        }
        return false;
    }

    public boolean isEllegibleToMarry() {
        for (UUID key : this.relationships.keySet()) {
            int value = this.getRelationship(key);
            if (value < HFNPCs.MARRIAGE_REQUIREMENT) continue;
            return true;
        }
        return false;
    }

    public String getLover() {
        return Text.translate("nolover");
    }
}

