/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.quests;

import java.util.HashSet;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.player.quests.QuestData;
import joshie.harvest.quests.packet.PacketQuestCompleted;
import joshie.harvest.quests.packet.PacketQuestSetAvailable;
import joshie.harvest.quests.packet.PacketQuestSetCurrent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;

public class QuestDataServer
extends QuestData {
    private final HashSet<Quest> finished = new HashSet();
    private final PlayerTrackerServer master;

    public QuestDataServer(PlayerTrackerServer master) {
        this.master = master;
    }

    public boolean hasCompleted(Quest quest) {
        return this.finished.contains((Object)quest);
    }

    @Override
    public boolean startQuest(Quest q) {
        if (this.current.size() < 100 || !q.isRealQuest()) {
            try {
                Quest quest = ((Quest)((Quest)((Object)((Object)((Object)q)).getClass().newInstance())).setRegistryName(q.getRegistryName())).setStage(0);
                this.current.add(quest);
                this.syncQuest(q, this.master.getAndCreatePlayer());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public void markCompleted(Quest quest) {
        Quest localQuest = this.getAQuest(quest);
        if (localQuest != null) {
            this.finished.add(localQuest);
            this.current.remove((Object)localQuest);
            localQuest.onQuestCompleted((EntityPlayer)this.master.getAndCreatePlayer());
        } else {
            this.finished.add(quest);
            quest.onQuestCompleted((EntityPlayer)this.master.getAndCreatePlayer());
        }
        PacketHandler.sendToClient(new PacketQuestCompleted(quest), (EntityPlayer)this.master.getAndCreatePlayer());
        this.sync(this.master.getAndCreatePlayer());
    }

    public void sync(EntityPlayerMP player) {
        for (Quest quest : Quest.REGISTRY.getValues()) {
            this.syncQuest(quest, player);
        }
    }

    public void syncQuest(Quest quest, EntityPlayerMP player) {
        if (!this.finished.contains((Object)quest) || quest.isRepeatable()) {
            if (this.current.contains((Object)quest)) {
                PacketHandler.sendToClient(new PacketQuestSetCurrent(this.getAQuest(quest)), (EntityPlayer)player);
            } else if (this.canStart(quest, (EntityPlayer)this.master.getAndCreatePlayer(), this.current, this.finished)) {
                PacketHandler.sendToClient(new PacketQuestSetAvailable(quest), (EntityPlayer)player);
            }
        }
    }

    private boolean canStart(Quest quest, EntityPlayer player, HashSet<Quest> active, HashSet<Quest> finished) {
        if (!quest.isRepeatable() && finished.contains((Object)quest)) {
            return false;
        }
        INPC[] npcs = quest.getNPCs();
        if (npcs != null) {
            for (Quest a : active) {
                if (!a.isRealQuest()) continue;
                for (INPC npc : npcs) {
                    for (INPC n : a.getNPCs()) {
                        if (!n.equals(npc)) continue;
                        return false;
                    }
                }
            }
        }
        return quest.canStartQuest(active, finished);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        NBTTagList list;
        if (nbt.func_74764_b("CurrentQuests")) {
            list = nbt.func_150295_c("CurrentQuests", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                Quest q = (Quest)Quest.REGISTRY.getValue(new ResourceLocation(tag.func_74779_i("QuestID")));
                try {
                    Quest quest = (Quest)((Quest)((Object)((Object)((Object)q)).getClass().newInstance())).setRegistryName(q.getRegistryName());
                    quest.readFromNBT(tag);
                    this.current.add(quest);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (nbt.func_74764_b("FinishedQuests")) {
            list = nbt.func_150295_c("FinishedQuests", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.finished.add((Quest)Quest.REGISTRY.getValue(new ResourceLocation(list.func_150307_f(i))));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList quests = new NBTTagList();
        for (Quest s : this.current) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("QuestID", s.getRegistryName().toString());
            s.writeToNBT(tag);
            quests.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("CurrentQuests", (NBTBase)quests);
        NBTTagList done = new NBTTagList();
        for (Quest s : this.finished) {
            if (s == null) continue;
            done.func_74742_a((NBTBase)new NBTTagString(s.getRegistryName().toString()));
        }
        nbt.func_74782_a("FinishedQuests", (NBTBase)done);
        return nbt;
    }
}

