/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.quests;

import java.util.HashSet;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.player.quests.QuestData;
import joshie.harvest.quests.packet.PacketQuestStart;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class QuestDataClient
extends QuestData {
    private final HashSet<Quest> available = new HashSet();

    @Override
    public void addAsCurrent(Quest quest) {
        this.current.add(quest);
    }

    @Override
    public void markCompleted(Quest quest) {
        Quest aQuest = this.getAQuest(quest);
        if (aQuest != null) {
            aQuest.onQuestCompleted((EntityPlayer)MCClientHelper.getPlayer());
        }
        if (!quest.isRepeatable()) {
            this.available.remove((Object)quest);
        }
        this.current.remove((Object)quest);
    }

    @Override
    public void setAvailable(Quest quest) {
        this.available.add(quest);
    }

    private String getScript(Quest quest, EntityPlayer player, EntityNPC entity) {
        return quest.getLocalizedScript(player, (EntityLiving)entity, entity.getNPC());
    }

    @Override
    public String getScript(EntityPlayer player, EntityNPC npc) {
        if (this.current != null) {
            for (Quest q : this.current) {
                String script;
                if (!this.handlesScript(q, npc.getNPC()) || (script = this.getScript(q, player, npc)) == null) continue;
                return script;
            }
            if (this.current.size() < 100) {
                for (Quest q : this.available) {
                    if (this.current.contains((Object)q) || !this.handlesScript(q, npc.getNPC())) continue;
                    try {
                        Quest quest = ((Quest)((Quest)((Object)((Object)((Object)q)).getClass().newInstance())).setRegistryName(q.getRegistryName())).setStage(0);
                        this.current.add(quest);
                        PacketHandler.sendToServer(new PacketQuestStart(q));
                        String script = this.getScript(q, player, npc);
                        if (script == null || !this.handlesScript(quest, npc.getNPC())) continue;
                        return script;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }
}

