/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.packet;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PenguinPacket;
import net.minecraft.entity.player.EntityPlayer;

@Packet(value=Packet.Side.CLIENT)
public class PacketSyncBirthday
extends PenguinPacket {
    private int day;
    private Season season;
    private int year;

    public PacketSyncBirthday() {
    }

    public PacketSyncBirthday(CalendarDate date) {
        this.day = date.getDay();
        this.season = date.getSeason();
        this.year = date.getYear();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.day);
        buf.writeByte(this.season.ordinal());
        buf.writeShort(this.year);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.day = buf.readByte();
        this.season = Season.values()[buf.readByte()];
        this.year = buf.readShort();
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        HFTrackers.getClientPlayerTracker().getStats().setBirthday(new CalendarDate(this.day, this.season, this.year));
    }
}

