/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import joshie.harvest.HarvestFestival;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.network.PenguinPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.logging.log4j.Level;

public abstract class PacketRelationship
extends PenguinPacket {
    private UUID key;
    private boolean particles;

    public PacketRelationship() {
    }

    public PacketRelationship(UUID key, boolean particles) {
        this.key = key;
        this.particles = particles;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key.toString());
        buf.writeBoolean(this.particles);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        try {
            this.key = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.particles = buf.readBoolean();
        }
        catch (Exception e) {
            HarvestFestival.LOGGER.log(Level.ERROR, "Failed to read a sync gift packet correctly");
        }
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        Object entity;
        if (this.particles && (entity = EntityHelper.getAnimalFromUUID(player.field_70170_p, this.key)) != null) {
            int j = 0;
            while ((double)j < 3.0) {
                double x = ((Entity)entity).field_70165_t - 0.5 + (double)player.field_70170_p.field_73012_v.nextFloat();
                double y = ((Entity)entity).field_70163_u - 0.5 + (double)player.field_70170_p.field_73012_v.nextFloat();
                double z = ((Entity)entity).field_70161_v - 0.5 + (double)player.field_70170_p.field_73012_v.nextFloat();
                player.field_70170_p.func_175688_a(EnumParticleTypes.HEART, x, 1.0 + y - 0.125, z, 0.0, 0.0, 0.0, new int[0]);
                ++j;
            }
        }
        this.handleRelationship(player, this.key);
    }

    protected abstract void handleRelationship(EntityPlayer var1, UUID var2);
}

