/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player.command;

import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.recipe.MealImpl;
import joshie.harvest.core.commands.AbstractHFCommand;
import joshie.harvest.core.commands.HFCommand;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.player.tracking.TrackingServer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;

@HFCommand
public class HFCommandRecipe
extends AbstractHFCommand {
    @Override
    public String getCommandName() {
        return "recipe";
    }

    @Override
    public String getUsage() {
        return "/hf recipe [player] <value|all|clear>";
    }

    @Override
    public boolean execute(MinecraftServer server, ICommandSender sender, String[] parameters) {
        if (parameters != null && (parameters.length == 1 || parameters.length == 2)) {
            try {
                EntityPlayerMP player = parameters.length == 1 ? CommandBase.func_71521_c((ICommandSender)sender) : CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)parameters[0]);
                TrackingServer tracking = ((PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer((EntityPlayer)player)).getTracking();
                String recipe = parameters[parameters.length - 1];
                if (recipe.equals("all")) {
                    for (MealImpl meal : CookingAPI.REGISTRY) {
                        tracking.learnRecipe(meal);
                    }
                    tracking.sync(player);
                    return true;
                }
                if (recipe.equals("clear")) {
                    tracking.learnRecipe(null);
                    tracking.sync(player);
                    return true;
                }
                if (!recipe.contains(":")) {
                    recipe = "harvestfestival:" + recipe;
                }
                tracking.learnRecipe((MealImpl)CookingAPI.REGISTRY.getValue(new ResourceLocation(recipe)));
                tracking.sync(player);
                return true;
            }
            catch (NumberFormatException | PlayerNotFoundException throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

