/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player;

import java.util.UUID;
import javax.annotation.Nullable;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.core.achievements.HFAchievements;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.player.quests.QuestDataServer;
import joshie.harvest.player.relationships.RelationshipDataServer;
import joshie.harvest.player.stats.StatsServer;
import joshie.harvest.player.tracking.TrackingServer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;

public class PlayerTrackerServer
extends PlayerTracker {
    private final QuestDataServer quests;
    private final RelationshipDataServer relationships;
    private final StatsServer stats;
    protected final TrackingServer tracking;
    private EntityPlayerMP player;
    private final UUID uuid;

    public PlayerTrackerServer(@Nullable EntityPlayerMP player, UUID uuid) {
        this.uuid = uuid;
        this.player = player != null ? player : this.getAndCreatePlayer();
        this.quests = new QuestDataServer(this);
        this.relationships = new RelationshipDataServer();
        this.stats = new StatsServer();
        this.tracking = new TrackingServer(this);
    }

    public EntityPlayerMP getAndCreatePlayer() {
        if (this.player == null) {
            this.player = EntityHelper.getPlayerFromUUID(this.uuid);
        }
        return this.player;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public RelationshipDataServer getRelationships() {
        return this.relationships;
    }

    @Override
    public QuestDataServer getQuests() {
        return this.quests;
    }

    @Override
    public StatsServer getStats() {
        return this.stats;
    }

    @Override
    public TrackingServer getTracking() {
        return this.tracking;
    }

    public void newDay() {
        this.relationships.newDay();
        EntityPlayerMP player = this.getAndCreatePlayer();
        if (player != null) {
            long gold = this.tracking.newDay();
            if (gold > 0L) {
                player.func_71029_a((StatBase)HFAchievements.firstShipping);
            }
            this.stats.addGold(null, gold);
            if (this.stats.getGold() >= 1000000L) {
                player.func_71029_a((StatBase)HFAchievements.millionaire);
            }
            this.syncPlayerStats(player);
            CalendarDate today = HFApi.calendar.getDate(player.field_70170_p);
            if (today.getSeason() == Season.WINTER && today.getDay() == 25) {
                player.func_71029_a((StatBase)HFAchievements.firstChristmas);
            }
            if (CalendarHelper.getYearsPassed(this.stats.getBirthday(), today) >= 1) {
                player.func_71029_a((StatBase)HFAchievements.birthday);
            }
        }
    }

    public void syncPlayerStats(EntityPlayerMP player) {
        if (player.field_71135_a != null && player.field_71135_a.field_147371_a != null) {
            this.quests.sync(player);
            this.relationships.sync(player);
            this.stats.sync(player);
            this.tracking.sync(player);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.quests.readFromNBT(nbt.func_74775_l("Quests"));
        this.relationships.readFromNBT(nbt.func_74775_l("Relationships"));
        this.stats.readFromNBT(nbt.func_74775_l("Stats"));
        this.tracking.readFromNBT(nbt.func_74775_l("Tracking"));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Quests", (NBTBase)this.quests.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("Relationships", (NBTBase)this.relationships.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("Stats", (NBTBase)this.stats.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("Tracking", (NBTBase)this.tracking.writeToNBT(new NBTTagCompound()));
        return nbt;
    }
}

