/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.player;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.annotation.Nullable;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.player.PlayerTrackerServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@HFEvents
public class PlayerLoader {
    private static File PLAYER_DIR;

    private static File getFolder(File playerDir) {
        File dir = new File(playerDir, "HF");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static PlayerTrackerServer getDataFromUUID(@Nullable EntityPlayerMP player, UUID uuid) {
        PlayerTrackerServer data = new PlayerTrackerServer(player, uuid);
        if (PLAYER_DIR != null) {
            File file = new File(PlayerLoader.getFolder(PLAYER_DIR), uuid + ".dat");
            if (!file.exists() && player != null) {
                file = new File(PlayerLoader.getFolder(PLAYER_DIR), EntityHelper.getLastKnownUUID((EntityPlayer)player) + ".dat");
            }
            if (file.exists()) {
                try {
                    FileInputStream fileinputstream = new FileInputStream(file);
                    NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                    fileinputstream.close();
                    data.readFromNBT(tag);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        HFTrackers.setPlayerData(uuid, data);
        return data;
    }

    @SubscribeEvent
    public void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        PLAYER_DIR = event.getPlayerDirectory();
        PlayerLoader.getDataFromUUID((EntityPlayerMP)event.getEntityPlayer(), EntityHelper.getPlayerUUID(event.getEntityPlayer()));
    }

    @SubscribeEvent
    public void onPlayerSave(PlayerEvent.SaveToFile event) {
        try {
            PlayerTrackerServer data = (PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer(event.getEntityPlayer());
            File file = new File(PlayerLoader.getFolder(event.getPlayerDirectory()), EntityHelper.getPlayerUUID(event.getEntityPlayer()) + ".dat");
            NBTTagCompound tag = data.writeToNBT(new NBTTagCompound());
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)fileoutputstream);
            fileoutputstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

