/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc.gui;

import java.io.IOException;
import java.util.Arrays;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.lib.HFModInfo;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.Text;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.gui.GuiNPCBase;
import joshie.harvest.npc.gui.ShopSelection;
import joshie.harvest.npc.packet.PacketGift;
import joshie.harvest.npc.packet.PacketInfo;
import joshie.harvest.npc.packet.PacketSelect;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;

public class GuiNPCSelect
extends GuiNPCBase {
    private static final Quest.Selection SHOPS = new ShopSelection();
    private Quest.Selection selection = new ShopSelection();
    private Quest quest;
    private String[] text;
    private int optionsStart;
    private int optionsTotal;
    private int selected;

    public GuiNPCSelect(EntityPlayer player, EntityNPC npc, int next, int selectionType) {
        super(player, npc, EnumHand.MAIN_HAND, next);
        if (selectionType == -1) {
            this.selection = SHOPS;
        } else {
            this.quest = HFTrackers.getClientPlayerTracker().getQuests().getAQuest((Quest)((Object)Quest.REGISTRY.getValues().get(selectionType)));
            Quest.Selection selection = this.selection = this.quest != null ? this.quest.getSelection(player, npc.getNPC()) : null;
        }
        if (this.selection != null && this.selection.getText() != null) {
            this.optionsTotal = 0;
            this.text = Arrays.copyOf(this.selection.getText(), this.selection.getText().length);
            this.selected = 1;
            boolean optionStarted = false;
            for (int i = 0; i < this.text.length; ++i) {
                String replaced;
                String original = Text.localize(this.text[i]);
                if (!original.equals(replaced = this.replace(original))) {
                    if (!optionStarted) {
                        optionStarted = true;
                        this.optionsStart = (byte)i;
                    }
                    ++this.optionsTotal;
                }
                this.text[i] = replaced;
            }
        }
    }

    private String replace(String string) {
        return string.replace("@", "    ");
    }

    @Override
    public void drawOverlay(int x, int y) {
        if (this.text != null) {
            for (int i = 0; i < this.text.length; ++i) {
                this.field_146289_q.func_78276_b(TextFormatting.BOLD + this.text[i], 22, 158 + i * 10, 0xFFFFFF);
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(HFModInfo.ELEMENTS);
            int position = this.selected + this.optionsStart;
            if (position == 1) {
                this.func_73729_b(20, 159, 0, 32, 19, 8);
            } else if (position == 2) {
                this.func_73729_b(20, 169, 0, 32, 19, 8);
            } else if (position == 3) {
                this.func_73729_b(20, 179, 0, 32, 19, 8);
            } else if (position == 4) {
                this.func_73729_b(20, 189, 0, 32, 19, 8);
            }
        }
    }

    public void adjustSelection(int number) {
        int newSelection = this.selected + number;
        if (newSelection > this.optionsTotal) {
            newSelection = 1;
        } else if (newSelection < 1) {
            newSelection = this.optionsTotal;
        }
        this.selected = (byte)newSelection;
    }

    @Override
    public void func_73869_a(char character, int key) throws IOException {
        super.func_73869_a(character, key);
        if (character == 'w' || key == 200) {
            this.adjustSelection(-1);
        }
        if (character == 's' || key == 208) {
            this.adjustSelection(1);
        }
        if (key == 28 || key == 57 || character == 'q') {
            this.select();
        }
    }

    private boolean isValidOption(int option) {
        int min = this.optionsStart;
        int max = this.optionsStart + this.optionsTotal;
        return option >= min && option <= max;
    }

    @Override
    public void onMouseClick(int mouseX, int mouseY) {
        if (this.isPointInRegion(242, 156, 17, 19, this.npcMouseX, this.npcMouseY)) {
            PacketHandler.sendToServer(new PacketGift(this.npc));
        } else if (this.npc.getNPC().hasInfo() != null && this.isPointInRegion(242, 177, 17, 19, this.npcMouseX, this.npcMouseY)) {
            PacketHandler.sendToServer(new PacketInfo(this.npc));
        } else if (this.selection != null) {
            if (mouseY >= 158 && mouseY <= 166 && this.isValidOption(0)) {
                this.selected = 1;
                this.select();
            } else if (mouseY >= 168 && mouseY <= 176 && this.isValidOption(1)) {
                this.selected = this.optionsStart == 0 ? 2 : 1;
                this.select();
            } else if (mouseY >= 178 && mouseY <= 186 && this.isValidOption(2)) {
                this.selected = this.optionsStart == 0 ? 3 : (this.optionsStart == 1 ? 2 : 1);
                this.select();
            } else if (mouseY >= 188 && mouseY <= 196 && this.isValidOption(3)) {
                this.selected = this.optionsStart == 0 ? 4 : (this.optionsStart == 1 ? 3 : (this.optionsStart == 2 ? 2 : 1));
                this.select();
            }
        }
    }

    private void select() {
        PacketHandler.sendToServer(new PacketSelect(this.quest, this.npc, this.selected));
    }
}

