/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc.gui;

import java.util.Locale;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.npc.gift.IGiftHandler;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.util.Text;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPCRegistry;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.gui.GuiNPCChat;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class GuiNPCGift
extends GuiNPCChat {
    private final ItemStack gift;
    private final IGiftHandler.Quality value;

    public GuiNPCGift(EntityPlayer player, EntityNPC npc, EnumHand hand) {
        super(player, npc, hand, -1, false);
        this.gift = player.func_184586_b(hand).func_77946_l();
        this.value = npc.getNPC().getGiftValue(this.gift);
    }

    @Override
    public String getScript() {
        if (NPCRegistry.INSTANCE.getGifts().isBlacklisted(this.gift)) {
            return Text.getSpeech(this.npc, "gift.no");
        }
        if (ToolHelper.isBlueFeather(this.gift)) {
            int relationship = HFApi.relationships.getRelationship(this.player, this.npc.getNPC().getUUID());
            if (relationship >= HFNPCs.MARRIAGE_REQUIREMENT && this.npc.getNPC().isMarriageCandidate()) {
                return Text.getSpeech(this.npc, "marriage.accept");
            }
            return Text.getSpeech(this.npc, "marriage.reject");
        }
        if (HFTrackers.getClientPlayerTracker().getRelationships().gift(this.player, this.npc.getNPC().getUUID(), this.value.getRelationPoints())) {
            return Text.getSpeech(this.npc, "gift." + this.value.name().toLowerCase(Locale.ENGLISH));
        }
        return Text.getSpeech(this.npc, "gift.reject");
    }

    @Override
    public void endChat() {
        this.player.func_71053_j();
    }
}

