/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.Text;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.gui.GuiNPCBase;
import joshie.harvest.npc.packet.PacketGift;
import joshie.harvest.npc.packet.PacketInfo;
import joshie.harvest.player.stats.StatsClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;

public class GuiNPCChat
extends GuiNPCBase {
    private static final int MAX_LINES_PER_PAGE = 4;
    private String[][] script;
    private int page;
    private int line;
    private double character;
    private boolean finished;
    private boolean isScriptInit = false;
    private boolean info = false;

    private String format(String string) {
        if (string == null) {
            return "FORGOT SOME TEXT DUMBASS";
        }
        StatsClient stats = HFTrackers.getClientPlayerTracker().getStats();
        String npcLover = this.npc.getLover() != null ? this.npc.getLover().getNPC().getLocalizedName() : Text.translate("nolover");
        String playerLover = HFTrackers.getClientPlayerTracker().getRelationships().getLover();
        return String.format(string, stats.getGold(), playerLover, npcLover, this.player.getDisplayNameString(), this.npc.getNPC().getLocalizedName());
    }

    public GuiNPCChat(EntityPlayer player, EntityNPC npc, EnumHand hand, int nextGui, boolean info) {
        super(player, npc, hand, nextGui);
        this.info = info;
    }

    private boolean buildScript() {
        boolean isRemainder;
        List formatted = this.field_146289_q.func_78271_c(this.format(this.getScript()), 172);
        String[] original = formatted.toArray(new String[formatted.size()]);
        int size = original.length / 4;
        boolean bl = isRemainder = original.length % 4 == 0;
        if (!isRemainder) {
            ++size;
        }
        int start = 0;
        this.script = new String[size][4];
        for (int i = 0; i < size; ++i) {
            int length = start + 4 > original.length ? original.length : start + 4;
            String[] subtext = Arrays.copyOfRange(original, start, length);
            for (int j = 0; j < subtext.length; ++j) {
                this.script[i][j] = subtext[j];
            }
            start += 4;
        }
        return true;
    }

    @Override
    public void drawOverlay(int x, int y) {
        if (!this.isScriptInit) {
            this.isScriptInit = this.buildScript();
        }
        if (this.script == null) {
            this.endChat();
        }
        if (!this.finished && this.line >= 2) {
            this.finished = true;
        }
        for (int i = 0; i < this.line; ++i) {
            String text = this.script[this.page][i];
            if (text == null) continue;
            this.field_146289_q.func_78276_b(TextFormatting.BOLD + text, 20, 157 + i * 10, 0xFFFFFF);
        }
        if (this.line < 4) {
            if (this.script[this.page][this.line] != null) {
                char[] todisplay = this.script[this.page][this.line].toCharArray();
                if (todisplay.length > 0) {
                    if (("" + todisplay[0]).equals("@")) {
                        this.character = todisplay.length;
                    }
                    if (this.character < (double)todisplay.length) {
                        this.character += 0.2;
                    }
                }
                char[] fordisplay = new char[(int)Math.ceil(this.character)];
                for (int i = 0; i < fordisplay.length; ++i) {
                    if (i >= todisplay.length) continue;
                    fordisplay[i] = todisplay[i];
                }
                this.field_146289_q.func_78276_b(TextFormatting.BOLD + new String(fordisplay), 20, 157 + this.line * 10, 0xFFFFFF);
                if (fordisplay.length >= todisplay.length) {
                    this.character = 0.0;
                    ++this.line;
                }
            } else {
                this.finished = true;
            }
        }
    }

    @Override
    protected void func_73869_a(char character, int key) throws IOException {
        super.func_73869_a(character, key);
        if (key == 28 || key == 57 || character == 'q') {
            this.nextChat();
        }
    }

    @Override
    protected void onMouseClick(int mouseX, int mouseY) {
        if (this.isPointInRegion(242, 156, 17, 19, this.npcMouseX, this.npcMouseY)) {
            PacketHandler.sendToServer(new PacketGift(this.npc));
        } else if (this.npc.getNPC().hasInfo() != null && this.isPointInRegion(242, 177, 17, 19, this.npcMouseX, this.npcMouseY)) {
            PacketHandler.sendToServer(new PacketInfo(this.npc));
        } else {
            this.nextChat();
        }
    }

    private void nextChat() {
        if (!this.finished) {
            this.finished = true;
            this.line = 4;
        } else if (this.page < this.script.length - 1) {
            this.finished = false;
            this.line = 0;
            ++this.page;
        } else {
            this.endChat();
        }
    }

    @Override
    public String getScript() {
        String infoGreeting;
        if (NPCHelper.isShopOpen(this.npc.getNPC(), this.player.field_70170_p, this.player) && this.nextGui == 5) {
            return this.npc.getNPC().getShop().getWelcome(this.player, this.npc);
        }
        String string = infoGreeting = this.info ? this.npc.getNPC().getInfoGreeting(this.player, this.npc) : null;
        if (infoGreeting != null) {
            return infoGreeting;
        }
        String script = HFTrackers.getClientPlayerTracker().getQuests().getScript(this.player, this.npc);
        return script == null ? this.npc.getNPC().getGreeting(this.player, this.npc) : script;
    }
}

