/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc.gui;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.core.base.gui.GuiBase;
import joshie.harvest.core.helpers.StackHelper;
import joshie.harvest.core.lib.HFModInfo;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.ChatFontRenderer;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.gui.ContainerNPCChat;
import joshie.harvest.npc.item.ItemNPCTool;
import joshie.harvest.npc.packet.PacketClose;
import joshie.harvest.npc.packet.PacketGift;
import joshie.harvest.npc.packet.PacketInfo;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class GuiNPCBase
extends GuiBase {
    public static final ItemStack GIFT = HFNPCs.TOOLS.getStackFromEnum(ItemNPCTool.NPCTool.GIFT);
    private static final ResourceLocation chatbox = new ResourceLocation("harvestfestival", "textures/gui/chatbox.png");
    protected final EntityNPC npc;
    protected final EntityPlayer player;
    protected final int nextGui;
    private final int inside;
    private final int outside;
    protected int npcMouseX;
    protected int npcMouseY;

    public GuiNPCBase(EntityPlayer ePlayer, EntityNPC eNpc, EnumHand hand, int next) {
        super(new ContainerNPCChat(ePlayer, eNpc, hand, next), "chat", 0);
        this.hasInventory = false;
        this.npc = eNpc;
        this.player = ePlayer;
        this.xSize = 256;
        this.ySize = 256;
        this.nextGui = next;
        this.inside = this.npc.getNPC().getInsideColor();
        this.outside = this.npc.getNPC().getOutsideColor();
    }

    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    @Override
    public void drawBackground(int x, int y) {
        GlStateManager.func_179094_E();
        this.field_146297_k.field_71446_o.func_110577_a(chatbox);
        this.func_73729_b(x, y + 150, 0, 150, 256, 51);
        GlStateManager.func_179147_l();
        ChatFontRenderer.colorise(this.inside);
        this.func_73729_b(x, y + 150, 0, 100, 256, 51);
        ChatFontRenderer.colorise(this.outside);
        this.func_73729_b(x, y + 150, 0, 50, 256, 51);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        ChatFontRenderer.render(this, x, y, this.npc.func_70005_c_(), this.inside, this.outside);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        this.field_146297_k.field_71446_o.func_110577_a(chatbox);
        if (this.isHoldingItem()) {
            if (!this.isPointInRegion(242, 156, 17, 19, this.npcMouseX, this.npcMouseY)) {
                ChatFontRenderer.colorise(this.inside);
            }
            this.func_73729_b(x + 241, y + 155, 218, 0, 19, 20);
            ChatFontRenderer.colorise(this.outside);
            this.func_73729_b(x + 241, y + 155, 237, 0, 19, 20);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            StackHelper.drawStack(GIFT, x + 242, y + 157, 1.0f);
        }
        if (this.displayInfo()) {
            this.field_146297_k.field_71446_o.func_110577_a(chatbox);
            if (!this.isPointInRegion(242, 177, 17, 19, this.npcMouseX, this.npcMouseY)) {
                ChatFontRenderer.colorise(this.inside);
            }
            this.func_73729_b(x + 241, y + 176, 218, 0, 19, 20);
            ChatFontRenderer.colorise(this.outside);
            this.func_73729_b(x + 241, y + 176, 237, 0, 19, 20);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            StackHelper.drawStack(this.npc.getNPC().hasInfo(), x + 242, y + 178, 1.0f);
        }
    }

    private void drawHeart(int value) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xPos = (int)((double)value / (double)HFNPCs.MAX_FRIENDSHIP * 7.0);
        this.func_73729_b(240, 130, 0, 0, 25, 25);
        this.func_73729_b(240, 130, 25 + 25 * xPos, 0, 25, 25);
    }

    @Override
    public void drawForeground(int x, int y) {
        boolean originalFlag = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        this.field_146297_k.field_71446_o.func_110577_a(HFModInfo.ELEMENTS);
        if (this.npc.getNPC().isMarriageCandidate()) {
            this.drawHeart(HFApi.relationships.getRelationship(this.player, this.npc.getNPC().getUUID()));
        }
        this.drawOverlay(x, y);
        this.field_146289_q.func_78264_a(originalFlag);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.npcMouseX = mouseX;
        this.npcMouseY = mouseY;
        if (this.isHoldingItem() && this.hoveringGift()) {
            this.func_146285_a(GIFT, mouseX, mouseY);
        }
        if (this.displayInfo() && this.hoveringInfo()) {
            this.func_146285_a(this.npc.getNPC().hasInfo(), mouseX, mouseY);
        }
    }

    @Override
    protected void onMouseClick(int mouseX, int mouseY) {
        if (this.isHoldingItem() && this.hoveringGift()) {
            PacketHandler.sendToServer(new PacketGift(this.npc));
        } else if (this.displayInfo() && this.hoveringInfo()) {
            PacketHandler.sendToServer(new PacketInfo(this.npc));
        }
    }

    private boolean hoveringGift() {
        return this.isPointInRegion(242, 156, 17, 19, this.npcMouseX, this.npcMouseY);
    }

    private boolean isHoldingItem() {
        return this.player.func_184614_ca() != null || this.player.func_184592_cb() != null;
    }

    private boolean hoveringInfo() {
        return this.isPointInRegion(242, 177, 17, 19, this.npcMouseX, this.npcMouseY);
    }

    private boolean displayInfo() {
        return this.npc.getNPC().hasInfo() != null && (this.npc.getNPC().getShop() == null || !this.npc.getNPC().getShop().isOpen(this.player.field_70170_p, this.player));
    }

    public abstract void drawOverlay(int var1, int var2);

    public void func_146276_q_() {
    }

    public String getScript() {
        return "missing chat";
    }

    public void endChat() {
        PacketHandler.sendToServer(new PacketClose());
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        ArrayList<String> textLines = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, false);
        for (int i = 0; i < textLines.size(); ++i) {
            if (i == 0) {
                textLines.set(i, stack.func_77953_t().field_77937_e + (String)textLines.get(i));
                continue;
            }
            textLines.set(i, TextFormatting.GRAY + (String)textLines.get(i));
        }
        GuiUtils.preItemToolTip((ItemStack)stack);
        if (!textLines.isEmpty()) {
            int borderColorStart;
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, (List)textLines, x, y, this.field_146294_l, this.field_146295_m, -1, this.field_146289_q);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            this.mouseX = event.getX();
            this.mouseY = event.getY();
            int screenWidth = event.getScreenWidth();
            int screenHeight = event.getScreenHeight();
            int maxTextWidth = event.getMaxWidth();
            this.field_146289_q = event.getFontRenderer();
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = this.field_146289_q.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = this.mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = this.mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = this.mouseX > screenWidth / 2 ? this.mouseX - 12 - 8 : screenWidth - 16 - this.mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = (String)textLines.get(i);
                    List wrappedLine = this.field_146289_q.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = this.field_146289_q.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = this.mouseX > screenWidth / 2 ? this.mouseX - 16 - tooltipTextWidth : this.mouseX + 12;
            }
            int tooltipY = this.mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            int zLevel = 300;
            int backgroundColor = 0xC8000000 | this.inside & 0xFFFFFF;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            int borderColorEnd = borderColorStart = 0xC8000000 | this.outside & 0xFFFFFF;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, tooltipX, tooltipY, this.field_146289_q, tooltipTextWidth, tooltipHeight));
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = (String)textLines.get(lineNumber);
                this.field_146289_q.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, tooltipX, tooltipTop, this.field_146289_q, tooltipTextWidth, tooltipHeight));
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
        GuiUtils.postItemToolTip();
    }
}

