/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc.entity.ai;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.buildings.BuildingLocation;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.entity.EntityNPCHuman;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAISchedule
extends EntityAIBase {
    private final EntityNPCHuman npc;
    private BuildingLocation location;
    private BlockPos blockTarget;
    private BlockPos prevTarget;
    private int teleportTimer;
    private int scheduleTimer;

    public EntityAISchedule(EntityNPCHuman npc) {
        this.npc = npc;
        this.func_75248_a(1);
    }

    private BuildingLocation getBuildingTarget(CalendarDate date) {
        if (NPCHelper.isShopPreparingToOpen(this.npc.getNPC(), this.npc.field_70170_p)) {
            return this.npc.getNPC().getLocation(INPC.Location.WORK);
        }
        return this.npc.getNPC().getScheduler().getTarget(this.npc.field_70170_p, (EntityLiving)this.npc, this.npc.getNPC(), date.getSeason(), date.getWeekday(), CalendarHelper.getTime(this.npc.field_70170_p));
    }

    public boolean func_75250_a() {
        this.updateTarget();
        return this.blockTarget != null && this.npc.func_174818_b(this.blockTarget) > this.location.getDistanceRequired();
    }

    public boolean func_75253_b() {
        return this.blockTarget != null;
    }

    private void updateTarget() {
        CalendarDate date = HFApi.calendar.getDate(this.npc.field_70170_p);
        this.location = this.getBuildingTarget(date);
        this.blockTarget = NPCHelper.getCoordinatesForLocation((EntityLivingBase)this.npc, this.location);
    }

    public void func_75246_d() {
        ++this.scheduleTimer;
        if (this.scheduleTimer % 200 == 0) {
            this.updateTarget();
        }
        if (this.blockTarget != null) {
            Path path;
            Vec3d vec;
            boolean tooFar;
            double distance = this.npc.func_174818_b(this.blockTarget);
            boolean bl = tooFar = distance > this.location.getDistanceRequired();
            if (tooFar) {
                if (this.scheduleTimer % 100 == 0) {
                    Vec3d vec2;
                    Path path2 = this.npc.func_70661_as().func_179680_a(this.blockTarget);
                    if (path2 == null && (vec2 = RandomPositionGenerator.func_75464_a((EntityCreature)this.npc, (int)32, (int)5, (Vec3d)new Vec3d((double)this.blockTarget.func_177958_n() + 0.5, (double)this.blockTarget.func_177956_o() + 1.0, (double)this.blockTarget.func_177952_p() + 0.5))) != null) {
                        path2 = this.npc.func_70661_as().func_179680_a(new BlockPos(vec2));
                    }
                    this.npc.func_70661_as().func_75484_a(path2, (double)0.6f);
                }
                this.teleportTimer = !this.blockTarget.equals((Object)this.prevTarget) ? 0 : ++this.teleportTimer;
                this.prevTarget = this.blockTarget;
                if (this.teleportTimer >= 600) {
                    this.teleportTimer = 0;
                    this.npc.func_184595_k((double)this.blockTarget.func_177958_n() + 0.5, (double)this.blockTarget.func_177956_o() + 1.0, (double)this.blockTarget.func_177952_p() + 0.5);
                }
            } else if (this.scheduleTimer % 300 == 0 && (vec = RandomPositionGenerator.func_75461_b((EntityCreature)this.npc, (int)((int)this.location.getDistanceRequired() / 2), (int)3, (Vec3d)new Vec3d((double)this.blockTarget.func_177958_n() + 0.5, (double)this.blockTarget.func_177956_o() + 1.0, (double)this.blockTarget.func_177952_p() + 0.5))) != null && (path = this.npc.func_70661_as().func_179680_a(new BlockPos(vec))) != null) {
                this.npc.func_70661_as().func_75484_a(path, (double)0.6f);
            }
        }
    }
}

