/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc.entity.ai;

import joshie.harvest.buildings.BuildingStage;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class EntityAIBuild
extends EntityAIBase {
    private final EntityNPCBuilder npc;
    private BlockPos prev;
    private int teleportTimer;
    private int buildingTimer;
    private int stuckTimer;

    public EntityAIBuild(EntityNPCBuilder npc) {
        this.npc = npc;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.npc.getBuilding() != null) {
            this.npc.field_70138_W = 1.0f;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.npc.getBuilding() == null) {
            this.teleportTimer = 0;
            return false;
        }
        return true;
    }

    private void attemptToTeleportToSafety(BlockPos go) {
        BlockPos pos;
        Vec3d vec = RandomPositionGenerator.func_75464_a((EntityCreature)this.npc, (int)3, (int)32, (Vec3d)new Vec3d((double)go.func_177958_n() + 0.5, (double)go.func_177956_o() + 1.0, (double)go.func_177952_p() + 0.5));
        if (vec != null && EntityHelper.isSpawnable(this.npc.field_70170_p, pos = new BlockPos(vec)) && EntityHelper.isSpawnable(this.npc.field_70170_p, pos.func_177984_a()) && this.npc.field_70170_p.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)this.npc.field_70170_p, pos.func_177977_b(), EnumFacing.UP)) {
            this.npc.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
        }
    }

    public void func_75246_d() {
        Placeable placeable;
        BuildingStage building = this.npc.getBuilding();
        if ((long)this.buildingTimer % building.getTickTime() == 0L && (placeable = building.next()) != null) {
            boolean tooFar;
            BlockPos go = building.getPos(building.previous());
            double distance = this.npc.func_174818_b(go);
            boolean bl = tooFar = distance >= building.getDistance(placeable);
            if (tooFar) {
                Vec3d vec;
                BlockPos current;
                if (this.teleportTimer >= 200 || distance >= 4096.0) {
                    this.teleportTimer = 0;
                    this.npc.func_184595_k((double)go.func_177958_n() + 0.5, (double)go.func_177956_o() + 1.0, (double)go.func_177952_p() + 0.5);
                    tooFar = false;
                }
                this.teleportTimer += (current = new BlockPos((Entity)this.npc)).equals((Object)this.prev) ? 10 : 1;
                this.prev = current;
                Path path = this.npc.func_70661_as().func_179680_a(go);
                if (path == null && (vec = RandomPositionGenerator.func_75464_a((EntityCreature)this.npc, (int)32, (int)5, (Vec3d)new Vec3d((double)go.func_177958_n() + 0.5, (double)go.func_177956_o() + 1.0, (double)go.func_177952_p() + 0.5))) != null) {
                    path = this.npc.func_70661_as().func_179680_a(new BlockPos(vec));
                }
                this.npc.func_70661_as().func_75484_a(path, (double)0.6f);
            } else {
                this.teleportTimer = 0;
            }
            if (!tooFar) {
                if (building.build(this.npc.field_70170_p)) {
                    this.npc.func_70661_as().func_75484_a(this.npc.func_70661_as().func_179680_a(go), 0.85);
                    this.stuckTimer = 0;
                } else {
                    Vec3d vec = RandomPositionGenerator.func_75464_a((EntityCreature)this.npc, (int)1, (int)1, (Vec3d)new Vec3d((double)go.func_177958_n() + 0.5, (double)go.func_177956_o() + 1.0, (double)go.func_177952_p() + 0.5));
                    if (vec != null) {
                        this.npc.func_70661_as().func_75484_a(this.npc.func_70661_as().func_179680_a(new BlockPos(vec)), (double)0.85f);
                    }
                    ++this.stuckTimer;
                    if (this.stuckTimer >= 100) {
                        this.stuckTimer = 0;
                        building.build(this.npc.field_70170_p);
                        this.attemptToTeleportToSafety(go);
                    }
                }
                if (building.isFinished()) {
                    this.npc.finishBuilding();
                    this.npc.resetSpawnHome();
                }
            }
            BlockPos pos = new BlockPos((Entity)this.npc);
            if (!this.npc.func_70055_a(Material.field_151579_a)) {
                this.attemptToTeleportToSafety(go);
            } else if (this.npc.field_70170_p.func_180495_p(pos).func_177230_c().func_176205_b((IBlockAccess)this.npc.field_70170_p, pos)) {
                this.npc.func_70637_d(true);
            }
        }
        ++this.buildingTimer;
    }
}

