/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc.entity;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.entity.ai.EntityAISchedule;
import joshie.harvest.npc.entity.ai.EntityAITalkingTo;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownDataServer;
import joshie.harvest.town.TownHelper;
import joshie.harvest.town.TownTracker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class EntityNPCHuman<E extends EntityNPCHuman>
extends EntityNPC<E> {
    protected BlockPos spawned;
    protected TownData homeTown;
    protected UUID townID;

    public EntityNPCHuman(World world) {
        super(world);
    }

    public EntityNPCHuman(World world, NPC npc) {
        super(world, npc);
    }

    public EntityNPCHuman(E entity) {
        super(entity);
    }

    protected void func_184651_r() {
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(true);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITalkingTo(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAISchedule(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
    }

    public BlockPos getHomeCoordinates() {
        BlockPos home = NPCHelper.getHomeForEntity(this);
        if (home == null) {
            home = this.spawned;
        }
        return home;
    }

    private <T extends TownData> T getHomeTown() {
        if (this.homeTown == null) {
            if (this.townID != null) {
                this.homeTown = TownHelper.getTownByID(this.field_70170_p, this.townID);
            } else {
                this.homeTown = TownHelper.getClosestTownToEntity((EntityLivingBase)this);
                this.townID = this.homeTown.getID();
            }
        }
        return (T)this.homeTown;
    }

    @Override
    public void resetSpawnHome() {
        TownHelper.createTownIfDoesntExist(this.field_70170_p, new BlockPos((Entity)this));
        this.homeTown = TownHelper.getClosestTownToEntity((EntityLivingBase)this);
        if (this.homeTown == TownTracker.NULL_TOWN) {
            this.func_70106_y();
        } else {
            this.townID = this.homeTown.getID();
            this.spawned = this.homeTown.getCoordinatesFor(this.getNPC().getLocation(INPC.Location.HOME));
            if (this.spawned == null) {
                this.spawned = new BlockPos((Entity)this);
            }
        }
    }

    public void setSpawnHome(TownData data) {
        this.homeTown = data;
        if (this.homeTown == TownTracker.NULL_TOWN) {
            this.func_70106_y();
        } else {
            this.townID = this.homeTown.getID();
            this.spawned = this.homeTown.getCoordinatesFor(this.getNPC().getLocation(INPC.Location.HOME));
            if (this.spawned == null) {
                this.spawned = new BlockPos((Entity)this);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70163_u >= -32.0 && this.npc.respawns()) {
            ((TownDataServer)this.getHomeTown()).markNPCDead(this.getNPC().getRegistryName());
            HFTrackers.markDirty(this.field_70170_p);
        }
        super.func_70645_a(cause);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0, true, false));
        return super.func_70097_a(source, amount);
    }

    @Override
    public void writeSpawnData(ByteBuf buf) {
        super.writeSpawnData(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.townID.toString());
    }

    @Override
    public void readSpawnData(ByteBuf buf) {
        super.readSpawnData(buf);
        this.townID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spawned = NBTHelper.readBlockPos("Original", nbt);
        this.townID = NBTHelper.readUUID("Town", nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTHelper.writeUUID("Town", nbt, this.townID);
        NBTHelper.writeBlockPos("Original", nbt, this.spawned);
    }
}

