/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import joshie.harvest.HarvestFestival;
import joshie.harvest.api.npc.INPCRegistry;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.NPCRegistry;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityNPC<E extends EntityNPC>
extends EntityAgeable
implements IEntityAdditionalSpawnData {
    protected NPC npc;
    protected EntityNPC lover;
    protected EntityPlayer talkingTo;
    protected Mode mode = Mode.DEFAULT;

    public EntityNPC(World world) {
        this(world, (NPC)HFNPCs.MAYOR);
    }

    public EntityNPC(World world, NPC npc) {
        super(world);
        this.npc = npc;
        this.func_110163_bv();
        this.func_70105_a(0.6f, 1.8f * npc.getHeight());
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70138_W = 0.7f;
    }

    public EntityNPC(E entity) {
        this(((EntityNPC)((Object)entity)).field_70170_p, ((EntityNPC)((Object)entity)).npc);
        this.npc = ((EntityNPC)((Object)entity)).getNPC();
        this.lover = ((EntityNPC)((Object)entity)).lover;
    }

    protected abstract E getNewEntity(E var1);

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public boolean isBusy() {
        return false;
    }

    public NPC getNPC() {
        return this.npc;
    }

    public EntityNPC getLover() {
        return this.lover;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String func_70005_c_() {
        return this.npc.getLocalizedName();
    }

    public boolean isTalking() {
        return this.talkingTo != null;
    }

    public void setTalking(EntityPlayer player) {
        this.talkingTo = player;
    }

    @Nullable
    public EntityPlayer getTalkingTo() {
        return this.talkingTo;
    }

    public boolean func_70631_g_() {
        return this.npc.getAge() == INPCRegistry.Age.CHILD;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public void resetSpawnHome() {
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        boolean flag;
        ItemStack held = player.func_184586_b(hand);
        boolean bl = flag = held != null && held.func_77973_b() == Items.field_151063_bx;
        if (!flag && this.func_70089_S()) {
            if (!this.field_70170_p.field_72995_K) {
                int guiID = NPCHelper.getGuiIDForNPC(this, this.field_70170_p, player);
                player.openGui((Object)HarvestFestival.instance, guiID, this.field_70170_p, this.func_145782_y(), -1, -1);
                this.setTalking(player);
            }
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.npc = (NPC)NPCRegistry.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("NPC")));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.npc != null) {
            nbt.func_74778_a("NPC", this.npc.getRegistryName().toString());
        }
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeBoolean(this.npc != null);
        if (this.npc != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.npc.getRegistryName().toString());
        }
    }

    public void readSpawnData(ByteBuf buf) {
        String name = buf.readBoolean() ? ByteBufUtils.readUTF8String((ByteBuf)buf) : "";
        this.npc = name.equals("") ? (NPC)HFNPCs.MAYOR : (NPC)NPCRegistry.REGISTRY.getValue(new ResourceLocation(name));
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return this.getNewEntity((EntityNPC)ageable);
    }

    public static enum Mode {
        DEFAULT,
        GIFT;

    }
}

