/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc;

import javax.annotation.Nullable;
import joshie.harvest.api.buildings.BuildingLocation;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.npc.entity.EntityNPCGoddess;
import joshie.harvest.npc.entity.EntityNPCShopkeeper;
import joshie.harvest.npc.entity.EntityNPCVillager;
import joshie.harvest.shops.Shop;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NPCHelper {
    public static BlockPos getCoordinatesForLocation(EntityLivingBase entity, BuildingLocation location) {
        return ((TownData)TownHelper.getClosestTownToEntity(entity)).getCoordinatesFor(location);
    }

    public static BlockPos getHomeForEntity(EntityNPC entity) {
        NPC npc = entity.getNPC();
        if (npc.getLocation(INPC.Location.HOME) == null) {
            return null;
        }
        return ((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)entity)).getCoordinatesFor(npc.getLocation(INPC.Location.HOME));
    }

    public static <N extends EntityNPC> N getEntityForNPC(World world, NPC npc) {
        if (npc.isBuilder()) {
            return (N)((Object)new EntityNPCBuilder(world, (INPC)npc));
        }
        if (npc.getShop() != null) {
            return (N)((Object)new EntityNPCShopkeeper(world, npc));
        }
        if (npc == HFNPCs.GODDESS) {
            return (N)((Object)new EntityNPCGoddess(world, npc));
        }
        return (N)((Object)new EntityNPCVillager(world, npc));
    }

    public static boolean isShopOpen(NPC npc, World world, @Nullable EntityPlayer player) {
        Shop shop = npc.getShop();
        if (shop != null && shop.isOpen(world, player)) {
            return player != null && shop.getContents(player).size() > 0 || player == null;
        }
        return false;
    }

    public static boolean isShopPreparingToOpen(NPC npc, World world) {
        Shop shop = npc.getShop();
        return shop != null && shop.isPreparingToOpen(world);
    }

    public static int getGuiIDForNPC(EntityNPC npc, World world, EntityPlayer player) {
        return !npc.isBusy() && NPCHelper.isShopOpen(npc.getNPC(), world, player) ? 6 : 0;
    }
}

