/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import joshie.harvest.api.buildings.Building;
import joshie.harvest.api.buildings.BuildingLocation;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.npc.IConditionalGreeting;
import joshie.harvest.api.npc.IGreeting;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.npc.INPCRegistry;
import joshie.harvest.api.npc.ISchedule;
import joshie.harvest.api.npc.gift.IGiftHandler;
import joshie.harvest.api.shops.IShop;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.core.util.Text;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPCRegistry;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.greeting.GreetingShop;
import joshie.harvest.npc.item.ItemNPCTool;
import joshie.harvest.shops.Shop;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;

public class NPC
extends IForgeRegistryEntry.Impl<NPC>
implements INPC {
    private final List<IConditionalGreeting> conditionals = new ArrayList<IConditionalGreeting>(256);
    private final EnumMap<INPC.Location, BuildingLocation> locations;
    private final String multipleLocalizationKey;
    private final String generalLocalizationKey;
    private final String localizationKey;
    private final ResourceLocation skin;
    private final UUID uuid;
    private final INPCRegistry.Age age;
    private final INPCRegistry.Gender gender;
    private final CalendarDate birthday;
    private final int insideColor;
    private final int outsideColor;
    private float height;
    private float offset;
    private IGiftHandler gifts;
    private ISchedule schedule;
    private boolean isBuilder;
    private Shop shop;
    private boolean doesRespawn;
    private boolean alex;
    private IGreeting infoGreeting;
    private ItemStack hasInfo;

    public NPC() {
        this(new ResourceLocation("harvestfestival", "null"), INPCRegistry.Gender.MALE, INPCRegistry.Age.ADULT, new CalendarDate(1, Season.SPRING, 1), 0, 0);
    }

    public NPC(ResourceLocation resource, INPCRegistry.Gender gender, INPCRegistry.Age age, CalendarDate birthday, int insideColor, int outsideColor) {
        String MODID = resource.func_110624_b();
        String name = resource.func_110623_a();
        this.age = age;
        this.gender = gender;
        this.height = 1.0f;
        this.birthday = birthday;
        this.doesRespawn = true;
        this.hasInfo = null;
        this.insideColor = insideColor;
        this.outsideColor = outsideColor;
        this.localizationKey = MODID + ".npc." + name + ".";
        this.generalLocalizationKey = MODID + ".npc.generic." + age.name().toLowerCase(Locale.ENGLISH) + ".";
        this.skin = new ResourceLocation(MODID, "textures/entity/" + name + ".png");
        this.multipleLocalizationKey = MODID + ".npc." + name + ".greeting";
        this.locations = new EnumMap(INPC.Location.class);
        this.uuid = UUID.nameUUIDFromBytes(resource.toString().getBytes());
        this.setRegistryName(resource);
        this.setupGifts();
        this.setupSchedules();
        NPCRegistry.REGISTRY.register((IForgeRegistryEntry)this);
    }

    @Override
    public INPC setIsBuilder() {
        this.isBuilder = true;
        return this;
    }

    @Override
    public INPC setHeight(float height, float offset) {
        this.height = height;
        this.offset = offset;
        return this;
    }

    @Override
    public INPC setShop(IShop shop) {
        this.shop = (Shop)shop;
        this.setHasInfo(HFNPCs.TOOLS.getStackFromEnum(ItemNPCTool.NPCTool.CLOCK), new GreetingShop(this.getRegistryName()));
        return this;
    }

    @Override
    public INPC setLocation(INPC.Location location, Building building, String home_location) {
        this.locations.put(location, new BuildingLocation(building, home_location));
        return this;
    }

    @Override
    public INPC setAlexSkin() {
        this.alex = true;
        return this;
    }

    @Override
    public INPC setNoRespawn() {
        this.doesRespawn = false;
        return this;
    }

    @Override
    public INPC setGiftHandler(IGiftHandler handler) {
        this.gifts = handler;
        return this;
    }

    @Override
    public INPC setScheduleHandler(ISchedule handler) {
        this.schedule = handler;
        return this;
    }

    @Override
    public INPC addGreeting(IConditionalGreeting greeting) {
        this.conditionals.add(greeting);
        return this;
    }

    @Override
    public INPC setHasInfo(ItemStack stack, IGreeting infoGreeting) {
        if (this.hasInfo == null || stack == null && infoGreeting == null) {
            this.hasInfo = stack;
            this.infoGreeting = infoGreeting;
        }
        return this;
    }

    public void setupGifts() {
        if (this.getRegistryName().func_110624_b().equals("harvestfestival")) {
            try {
                this.gifts = (IGiftHandler)Class.forName("joshie.harvest.npc.gift.Gifts" + WordUtils.capitalize((String)this.getRegistryName().func_110623_a())).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.gifts == null) {
            this.gifts = new IGiftHandler(){};
        }
    }

    public void setupSchedules() {
        if (this.getRegistryName().func_110624_b().equals("harvestfestival")) {
            try {
                this.schedule = (ISchedule)Class.forName("joshie.harvest.npc.schedule.Schedule" + WordUtils.capitalize((String)this.getRegistryName().func_110623_a())).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.schedule == null) {
            this.schedule = new ISchedule(){};
        }
    }

    @Override
    public INPCRegistry.Age getAge() {
        return this.age;
    }

    @Override
    public INPCRegistry.Gender getGender() {
        return this.gender;
    }

    @Override
    public boolean isMarriageCandidate() {
        return this.age == INPCRegistry.Age.ADULT;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public float getHeight() {
        return this.height;
    }

    public float getOffset() {
        return this.offset;
    }

    @Override
    public boolean isBuilder() {
        return this.isBuilder;
    }

    public Shop getShop() {
        return this.shop;
    }

    @Override
    public CalendarDate getBirthday() {
        return this.birthday;
    }

    @Override
    public BuildingLocation getLocation(INPC.Location residence) {
        return this.locations.get((Object)residence);
    }

    @Override
    public String getLocalizedName() {
        return Text.localize(this.getRegistryName().func_110624_b() + ".npc." + this.getRegistryName().func_110623_a() + ".name");
    }

    public String getInfoGreeting(EntityPlayer player, EntityNPC npc) {
        if (this.infoGreeting == null) {
            return null;
        }
        return this.infoGreeting.getLocalizedText(player, npc, npc.getNPC());
    }

    public ResourceLocation getSkin() {
        return this.skin;
    }

    public int getBedtime() {
        return this.age == INPCRegistry.Age.CHILD ? 19000 : 23000;
    }

    public String getLocalizationKey() {
        return this.localizationKey;
    }

    public String getGeneralLocalizationKey() {
        return this.generalLocalizationKey;
    }

    @Override
    public ResourceLocation getResource() {
        return this.getRegistryName();
    }

    public String getGreeting(EntityPlayer player, EntityAgeable entity) {
        Collections.shuffle(this.conditionals);
        for (IConditionalGreeting greeting : this.conditionals) {
            if (!greeting.canDisplay(player, entity, this) || !(player.field_70170_p.field_73012_v.nextDouble() * 100.0 < greeting.getDisplayChance())) continue;
            return greeting.getLocalizedText(player, entity, this);
        }
        return Text.getRandomSpeech(this, this.multipleLocalizationKey, 100, new Object[0]);
    }

    @Override
    public IGiftHandler.Quality getGiftValue(ItemStack stack) {
        if (this.gifts == null) {
            return IGiftHandler.Quality.DECENT;
        }
        if (stack.func_77973_b() == HFCooking.MEAL && !stack.func_77942_o()) {
            return IGiftHandler.Quality.DISLIKE;
        }
        return this.gifts.getQuality(stack);
    }

    public ItemStack hasInfo() {
        return this.hasInfo;
    }

    public ISchedule getScheduler() {
        return this.schedule;
    }

    public int getInsideColor() {
        return this.insideColor;
    }

    public int getOutsideColor() {
        return this.outsideColor;
    }

    public boolean isAlexSkin() {
        return this.alex;
    }

    public boolean respawns() {
        return this.doesRespawn;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return this.getRegistryName().equals((Object)((NPC)o).getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }
}

