/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.npc;

import joshie.harvest.HarvestFestival;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.npc.INPCRegistry;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.HFClientProxy;
import joshie.harvest.core.base.MeshIdentical;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.helpers.RegistryHelper;
import joshie.harvest.core.util.HFLoader;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCRegistry;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.npc.entity.EntityNPCGoddess;
import joshie.harvest.npc.entity.EntityNPCShopkeeper;
import joshie.harvest.npc.entity.EntityNPCVillager;
import joshie.harvest.npc.greeting.GreetingCarpenter;
import joshie.harvest.npc.greeting.GreetingLocation;
import joshie.harvest.npc.greeting.GreetingTime;
import joshie.harvest.npc.greeting.GreetingWeather;
import joshie.harvest.npc.item.ItemNPCSpawner;
import joshie.harvest.npc.item.ItemNPCTool;
import joshie.harvest.npc.render.NPCItemRenderer;
import joshie.harvest.npc.render.RenderNPC;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFLoader(priority=5)
public class HFNPCs {
    public static final NPC NULL_NPC = new NPC();
    public static INPC GODDESS;
    public static INPC ANIMAL_OWNER;
    public static INPC CAFE_OWNER;
    public static INPC CAFE_GRANNY;
    public static INPC SEED_OWNER;
    public static INPC TOOL_OWNER;
    public static INPC PRIEST;
    public static INPC MAYOR;
    public static INPC DAUGHTER_1;
    public static INPC DAUGHTER_2;
    public static INPC CLOCK_WORKER;
    public static INPC CLOCKMAKER_CHILD;
    public static INPC GS_OWNER;
    public static INPC MINER;
    public static INPC FISHERMAN;
    public static INPC MILKMAID;
    public static INPC BUILDER;
    public static INPC POULTRY;
    public static INPC TRADER;
    public static final ItemNPCSpawner SPAWNER_NPC;
    public static final ItemNPCTool TOOLS;
    public static int MAX_FRIENDSHIP;
    public static int MARRIAGE_REQUIREMENT;
    public static double TOWN_DISTANCE;

    public static void preInit() {
        EntityRegistry.registerModEntity(EntityNPCVillager.class, (String)"villager", (int)0, (Object)HarvestFestival.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityNPCBuilder.class, (String)"builder", (int)1, (Object)HarvestFestival.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityNPCShopkeeper.class, (String)"shopkeeper", (int)2, (Object)HarvestFestival.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityNPCGoddess.class, (String)"goddess", (int)10, (Object)HarvestFestival.instance, (int)80, (int)3, (boolean)true);
        RegistryHelper.registerSounds("goddess", "blessing");
        GODDESS = HFNPCs.register("goddess", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ADULT, 8, Season.SPRING, 9236179, 5162117).setHeight(1.2f, 0.6f);
        ANIMAL_OWNER = HFNPCs.register("jim", INPCRegistry.Gender.MALE, INPCRegistry.Age.ADULT, 26, Season.SPRING, 14578245, 7482137);
        CAFE_OWNER = HFNPCs.register("liara", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ADULT, 17, Season.SPRING, 12503278, 8425936);
        SEED_OWNER = HFNPCs.register("jade", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ADULT, 14, Season.SPRING, 6631553, 3545152);
        DAUGHTER_1 = HFNPCs.register("cloe", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ADULT, 3, Season.SPRING, 0xFFFF99, 0xB2B200);
        PRIEST = HFNPCs.register("thomas", INPCRegistry.Gender.MALE, INPCRegistry.Age.ELDER, 9, Season.SUMMER, 26214, 731936);
        CLOCKMAKER_CHILD = HFNPCs.register("fenn", INPCRegistry.Gender.MALE, INPCRegistry.Age.CHILD, 25, Season.SUMMER, 2264064, 16128);
        CAFE_GRANNY = HFNPCs.register("katlin", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ELDER, 12, Season.SUMMER, 0xDDDDDD, 0x777777);
        MAYOR = HFNPCs.register("jamie", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ELDER, 8, Season.SUMMER, 11054234, 3892077);
        BUILDER = HFNPCs.register("yulif", INPCRegistry.Gender.MALE, INPCRegistry.Age.ADULT, 19, Season.SUMMER, 3225687, 0x121421).setIsBuilder();
        TOOL_OWNER = HFNPCs.register("daniel", INPCRegistry.Gender.MALE, INPCRegistry.Age.ADULT, 1, Season.WINTER, 6371367, 2299150);
        DAUGHTER_2 = HFNPCs.register("abi", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.CHILD, 27, Season.WINTER, 0xFF99FF, 0xFF20FF);
        CLOCK_WORKER = HFNPCs.register("tiberius", INPCRegistry.Gender.MALE, INPCRegistry.Age.ADULT, 15, Season.WINTER, 3168814, 1319961);
        GS_OWNER = HFNPCs.register("jenni", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ADULT, 7, Season.WINTER, 0xDDD0AD, 15175747);
        MINER = HFNPCs.register("brandon", INPCRegistry.Gender.MALE, INPCRegistry.Age.ADULT, 13, Season.AUTUMN, 12750152, 6246983);
        FISHERMAN = HFNPCs.register("jacob", INPCRegistry.Gender.MALE, INPCRegistry.Age.ADULT, 28, Season.AUTUMN, 7575295, 14041);
        MILKMAID = HFNPCs.register("candice", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ADULT, 5, Season.AUTUMN, 16146347, 15866245);
        POULTRY = HFNPCs.register("ashlee", INPCRegistry.Gender.FEMALE, INPCRegistry.Age.ADULT, 16, Season.AUTUMN, 12987693, 0x571111);
        TRADER = HFNPCs.register("girafi", INPCRegistry.Gender.MALE, INPCRegistry.Age.ADULT, 2, Season.AUTUMN, 0xFFFFFF, 12979248);
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        ModelLoader.setCustomMeshDefinition((Item)SPAWNER_NPC, (ItemMeshDefinition)new MeshIdentical(SPAWNER_NPC));
        HFNPCs.registerNPCRendering(EntityNPCVillager.class);
        HFNPCs.registerNPCRendering(EntityNPCBuilder.class);
        HFNPCs.registerNPCRendering(EntityNPCShopkeeper.class);
        HFNPCs.registerNPCRendering(EntityNPCGoddess.class);
    }

    public static void init() {
        GODDESS.setLocation(INPC.Location.HOME, HFBuildings.GODDESS_POND, "goddess.front").setHasInfo(TOOLS.getStackFromEnum(ItemNPCTool.NPCTool.WEATHER), new GreetingWeather());
        ANIMAL_OWNER.setLocation(INPC.Location.HOME, HFBuildings.BARN, "jim").setLocation(INPC.Location.WORK, HFBuildings.BARN, "jim");
        CAFE_OWNER.setLocation(INPC.Location.HOME, HFBuildings.CAFE, "liara").setLocation(INPC.Location.WORK, HFBuildings.CAFE, "cafe.till");
        SEED_OWNER.setLocation(INPC.Location.HOME, HFBuildings.CARPENTER, "jade").setLocation(INPC.Location.WORK, HFBuildings.CARPENTER, "jade");
        DAUGHTER_1.setLocation(INPC.Location.HOME, HFBuildings.TOWNHALL, "cloe");
        PRIEST.setLocation(INPC.Location.HOME, HFBuildings.TOWNHALL, "townhall.bedroom.adult").setLocation(INPC.Location.WORK, HFBuildings.CHURCH, "thomas");
        CLOCKMAKER_CHILD.setLocation(INPC.Location.HOME, HFBuildings.CLOCKMAKER, "fenn");
        CAFE_GRANNY.setLocation(INPC.Location.HOME, HFBuildings.CAFE, "katlin");
        MAYOR.setLocation(INPC.Location.HOME, HFBuildings.TOWNHALL, "jamie").setLocation(INPC.Location.WORK, HFBuildings.TOWNHALL, "townhall.entrance");
        BUILDER.setLocation(INPC.Location.HOME, HFBuildings.CARPENTER, "carpenter.downstairs").setLocation(INPC.Location.WORK, HFBuildings.CARPENTER, "carpenter.door").addGreeting(new GreetingCarpenter());
        TOOL_OWNER.setLocation(INPC.Location.HOME, HFBuildings.BLACKSMITH, "daniel").setLocation(INPC.Location.WORK, HFBuildings.BLACKSMITH, "daniel");
        DAUGHTER_2.setLocation(INPC.Location.HOME, HFBuildings.TOWNHALL, "abi");
        CLOCK_WORKER.setLocation(INPC.Location.HOME, HFBuildings.CLOCKMAKER, "tiberius");
        GS_OWNER.setLocation(INPC.Location.HOME, HFBuildings.SUPERMARKET, "jenni").setLocation(INPC.Location.WORK, HFBuildings.SUPERMARKET, "market.till");
        MINER.setLocation(INPC.Location.HOME, HFBuildings.MINING_HUT, "brandon").setLocation(INPC.Location.WORK, HFBuildings.MINING_HUT, "miner.gravel");
        FISHERMAN.setLocation(INPC.Location.HOME, HFBuildings.FISHING_HUT, "jacob").addGreeting(new GreetingLocation(HFBuildings.FISHING_HOLE, "pond.pier"));
        MILKMAID.setLocation(INPC.Location.HOME, HFBuildings.SUPERMARKET, "candice").setLocation(INPC.Location.WORK, HFBuildings.BARN, "barn.left");
        POULTRY.setLocation(INPC.Location.HOME, HFBuildings.POULTRY_FARM, "ashlee").setLocation(INPC.Location.WORK, HFBuildings.POULTRY_FARM, "ashlee");
        TRADER.setLocation(INPC.Location.HOME, HFBuildings.TOWNHALL, "townhall.wing.right").setLocation(INPC.Location.WORK, HFBuildings.SUPERMARKET, "girafi");
        CLOCK_WORKER.setHasInfo(TOOLS.getStackFromEnum(ItemNPCTool.NPCTool.CALENDAR), new GreetingTime());
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        HFClientProxy.RENDER_MAP.put(SPAWNER_NPC, NPCItemRenderer.NPCTile.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(NPCItemRenderer.NPCTile.class, (TileEntitySpecialRenderer)new NPCItemRenderer());
        for (NPC npc : NPCRegistry.REGISTRY) {
            ItemStack stack = SPAWNER_NPC.getStackFromObject(npc);
            ForgeHooksClient.registerTESRItemStack((Item)stack.func_77973_b(), (int)stack.func_77952_i(), NPCItemRenderer.NPCTile.class);
        }
    }

    private static INPC register(String name, INPCRegistry.Gender gender, INPCRegistry.Age age, int dayOfBirth, Season seasonOfBirth, int insideColor, int outsideColor) {
        return HFApi.npc.register(new ResourceLocation("harvestfestival", name), gender, age, dayOfBirth, seasonOfBirth, insideColor, outsideColor);
    }

    private static <E extends EntityNPC> void registerNPCRendering(Class<E> entityClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, RenderNPC::new);
    }

    public static void configure() {
        MAX_FRIENDSHIP = ConfigHelper.getInteger("Maximum friendship", 65535);
        MARRIAGE_REQUIREMENT = ConfigHelper.getInteger("Marriage requirement", 60000);
        TOWN_DISTANCE = ConfigHelper.getDouble("Distance between towns", 256.0);
    }

    static {
        SPAWNER_NPC = (ItemNPCSpawner)new ItemNPCSpawner().register("spawner_npc");
        TOOLS = (ItemNPCTool)new ItemNPCTool().register("tool_npc");
    }
}

