/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import joshie.harvest.core.render.BakedHF;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.block.BlockDirt;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BakedDirt
extends BakedHF {
    private final IBakedModel overlay;
    protected final List<WeightedTexture> textures;
    private final int totalWeight;

    public BakedDirt(IBakedModel parent, IBakedModel overlay, List<WeightedTexture> overlays) {
        super(parent);
        this.overlay = overlay;
        this.textures = overlays;
        this.totalWeight = WeightedRandom.func_76272_a(this.textures);
    }

    private TextureAtlasSprite getRandomTexture(long rand) {
        return ((WeightedTexture)WeightedRandom.func_180166_a(this.textures, (int)(Math.abs((int)((int)rand >> 16)) % this.totalWeight))).sprite;
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(BakedDirt.super.func_188616_a(state, side, rand));
        this.overlay.func_188616_a(state, side, rand).stream().map(quad -> new BakedQuadRetextured(quad, this.getRandomTexture(rand))).forEachOrdered(quads::add);
        return quads;
    }

    private static class WeightedTexture
    extends WeightedRandom.Item {
        public final TextureAtlasSprite sprite;

        public WeightedTexture(TextureAtlasSprite sprite, int weight) {
            super(weight);
            this.sprite = sprite;
        }
    }

    public static enum TextureType {
        BLANK(200),
        BONES1(1),
        BONES2(1),
        BONES3(1),
        BONES4(1),
        LEAVES1(1),
        LEAVES2(1),
        LEAVES3(1),
        LEAVES4(1),
        PEBBLE1(1),
        PEBBLE2(1),
        PEBBLE3(1),
        PEBBLE4(1),
        PEBBLE5(1),
        PEBBLE6(1),
        ROCK1(1),
        ROCK2(1);

        private final int weight;

        private TextureType(int weight) {
            this.weight = weight;
        }
    }

    @HFEvents
    public static class StateMapper
    extends DefaultStateMapper {
        private static final String[] VALID_STATES = new String[]{"ne=blank,nw=blank,se=blank,sw=blank", "ne=blank,nw=blank,se=blank,sw=inner", "ne=blank,nw=blank,se=horizontal,sw=horizontal", "ne=blank,nw=blank,se=inner,sw=blank", "ne=blank,nw=blank,se=inner,sw=inner", "ne=blank,nw=inner,se=blank,sw=blank", "ne=blank,nw=inner,se=blank,sw=inner", "ne=blank,nw=inner,se=horizontal,sw=horizontal", "ne=blank,nw=inner,se=inner,sw=blank", "ne=blank,nw=inner,se=inner,sw=inner", "ne=blank,nw=vertical,se=blank,sw=vertical", "ne=blank,nw=vertical,se=horizontal,sw=outer", "ne=blank,nw=vertical,se=inner,sw=vertical", "ne=horizontal,nw=horizontal,se=blank,sw=blank", "ne=horizontal,nw=horizontal,se=blank,sw=inner", "ne=horizontal,nw=horizontal,se=horizontal,sw=horizontal", "ne=horizontal,nw=horizontal,se=inner,sw=blank", "ne=horizontal,nw=horizontal,se=inner,sw=inner", "ne=horizontal,nw=outer,se=blank,sw=vertical", "ne=horizontal,nw=outer,se=horizontal,sw=outer", "ne=horizontal,nw=outer,se=inner,sw=vertical", "ne=inner,nw=blank,se=blank,sw=blank", "ne=inner,nw=blank,se=blank,sw=inner", "ne=inner,nw=blank,se=horizontal,sw=horizontal", "ne=inner,nw=blank,se=inner,sw=blank", "ne=inner,nw=blank,se=inner,sw=inner", "ne=inner,nw=inner,se=blank,sw=blank", "ne=inner,nw=inner,se=blank,sw=inner", "ne=inner,nw=inner,se=horizontal,sw=horizontal", "ne=inner,nw=inner,se=inner,sw=blank", "ne=inner,nw=inner,se=inner,sw=inner", "ne=inner,nw=vertical,se=blank,sw=vertical", "ne=inner,nw=vertical,se=horizontal,sw=outer", "ne=inner,nw=vertical,se=inner,sw=vertical", "ne=outer,nw=horizontal,se=outer,sw=horizontal", "ne=outer,nw=horizontal,se=vertical,sw=blank", "ne=outer,nw=horizontal,se=vertical,sw=inner", "ne=outer,nw=outer,se=outer,sw=outer", "ne=outer,nw=outer,se=vertical,sw=vertical", "ne=vertical,nw=blank,se=outer,sw=horizontal", "ne=vertical,nw=blank,se=vertical,sw=blank", "ne=vertical,nw=blank,se=vertical,sw=inner", "ne=vertical,nw=inner,se=outer,sw=horizontal", "ne=vertical,nw=inner,se=vertical,sw=blank", "ne=vertical,nw=inner,se=vertical,sw=inner", "ne=vertical,nw=vertical,se=outer,sw=outer", "ne=vertical,nw=vertical,se=vertical,sw=vertical"};

        private boolean isValidState(String state) {
            for (String s : VALID_STATES) {
                if (!state.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }

        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
            if (block == HFMining.DIRT) {
                this.field_178133_b.put(new BlockStateContainer(block, new IProperty[0]).func_177621_b(), new ModelResourceLocation(block.getRegistryName(), "overlay"));
            }
            for (IBlockState iblockstate : block.func_176194_O().func_177619_a()) {
                ModelResourceLocation model = this.func_178132_a(iblockstate);
                if (model == null) continue;
                this.field_178133_b.put(iblockstate, model);
            }
            return this.field_178133_b;
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            String properties = this.func_178131_a((Map)state.func_177228_b());
            if (!this.isValidState(properties)) {
                return null;
            }
            return new ModelResourceLocation("harvestfestival:dirt", properties);
        }

        @SubscribeEvent
        public void onStitch(TextureStitchEvent event) {
            for (TextureType type : TextureType.values()) {
                event.getMap().func_174942_a(new ResourceLocation("harvestfestival", "blocks/mine/overlays/" + type.name().toLowerCase(Locale.ENGLISH)));
            }
        }

        @SubscribeEvent
        public void onBaking(ModelBakeEvent event) {
            IRegistry registry = event.getModelRegistry();
            IBakedModel overlay = (IBakedModel)registry.func_82594_a((Object)new ModelResourceLocation("harvestfestival:dirt", "overlay"));
            ArrayList<WeightedTexture> overlays = new ArrayList<WeightedTexture>();
            for (TextureType textureType : TextureType.values()) {
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("harvestfestival:blocks/mine/overlays/" + textureType.name().toLowerCase(Locale.ENGLISH));
                overlays.add(new WeightedTexture(sprite, textureType.weight));
            }
            for (Enum enum_ : BlockDirt.TextureStyle.values()) {
                for (BlockDirt.TextureStyle nw : BlockDirt.TextureStyle.values()) {
                    for (BlockDirt.TextureStyle se : BlockDirt.TextureStyle.values()) {
                        for (BlockDirt.TextureStyle sw : BlockDirt.TextureStyle.values()) {
                            String state = String.format("ne=%s,nw=%s,se=%s,sw=%s", ((BlockDirt.TextureStyle)enum_).func_176610_l(), nw.func_176610_l(), se.func_176610_l(), sw.func_176610_l());
                            IBakedModel original = (IBakedModel)registry.func_82594_a((Object)new ModelResourceLocation("harvestfestival:dirt", state));
                            registry.func_82595_a((Object)new ModelResourceLocation("harvestfestival:dirt", state), (Object)new BakedDirt(original, overlay, overlays));
                        }
                    }
                }
            }
        }
    }
}

