/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import joshie.harvest.mining.loot.FloorCondition;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class MultipleOf
extends FloorCondition {
    private final int multiple;
    private final boolean reverse;

    public MultipleOf(int multiple, boolean reverse) {
        this.multiple = multiple;
        this.reverse = reverse;
    }

    @Override
    public boolean testFloor(int floor) {
        if (this.reverse) {
            return floor % this.multiple != 0;
        }
        return floor % this.multiple == 0;
    }

    public static class Serializer
    extends LootCondition.Serializer<MultipleOf> {
        public Serializer() {
            super(new ResourceLocation("harvestfestival", "multiple"), MultipleOf.class);
        }

        public void serialize(JsonObject json, MultipleOf value, JsonSerializationContext context) {
            json.addProperty("of", (Number)value.multiple);
            if (value.reverse) {
                json.addProperty("reverse", Boolean.valueOf(true));
            }
        }

        public MultipleOf deserialize(JsonObject json, JsonDeserializationContext context) {
            return new MultipleOf(JsonUtils.func_151208_a((JsonObject)json, (String)"of", (int)0), JsonUtils.func_151209_a((JsonObject)json, (String)"reverse", (boolean)false));
        }
    }
}

