/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import joshie.harvest.mining.loot.FloorCondition;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class Exact
extends FloorCondition {
    private final int[] values;

    public Exact(int[] value) {
        this.values = value;
    }

    @Override
    public boolean testFloor(int floor) {
        for (int value : this.values) {
            if (value != floor) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<Exact> {
        public Serializer() {
            super(new ResourceLocation("harvestfestival", "exact"), Exact.class);
        }

        public void serialize(JsonObject json, Exact value, JsonSerializationContext context) {
            if (value.values.length == 1) {
                json.addProperty("value", (Number)value.values[0]);
            } else {
                JsonArray array = new JsonArray();
                for (int v : value.values) {
                    array.add((JsonElement)new JsonPrimitive((Number)v));
                }
                json.add("values", (JsonElement)array);
            }
        }

        public Exact deserialize(JsonObject json, JsonDeserializationContext context) {
            if (json.has("values")) {
                JsonArray array = json.getAsJsonArray("values");
                int[] values = new int[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    values[i] = array.get(i).getAsInt();
                }
                return new Exact(values);
            }
            if (json.has("value")) {
                int[] values = new int[]{JsonUtils.func_151208_a((JsonObject)json, (String)"value", (int)0)};
                return new Exact(values);
            }
            return new Exact(new int[0]);
        }
    }
}

