/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.gen;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.lib.LootStrings;
import joshie.harvest.core.util.annotations.HFEvents;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MiningHelper;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.entity.EntityNPC;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

@HFEvents
public class MineManager
extends WorldSavedData {
    public static final int CHUNK_BOUNDARY = 10;
    private static final TIntObjectMap<TIntObjectMap<IBlockState[][]>> generation = new TIntObjectHashMap();
    private static final TIntObjectMap<int[]> coordinates = new TIntObjectHashMap();
    private TIntObjectMap<TIntObjectMap<BlockPos>> portalCoordinates = new TIntObjectHashMap();
    private TIntSet generated = new TIntHashSet();

    public MineManager(String string) {
        super(string);
    }

    public void func_76184_a(@Nonnull NBTTagCompound tag) {
        this.portalCoordinates = NBTHelper.readPositionCollection(tag.func_150295_c("PortalCoordinates", 10));
        if (tag.func_74764_b("GeneratedMiner")) {
            this.generated = new TIntHashSet(tag.func_74759_k("GeneratedMiner"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound tag) {
        tag.func_74782_a("PortalCoordinates", (NBTBase)NBTHelper.writePositionCollection(this.portalCoordinates));
        tag.func_74783_a("GeneratedMiner", this.generated.toArray());
        return tag;
    }

    private BlockPos modifyNPCPosition(WorldServer dim, BlockPos spawn, Entity entity) {
        IBlockState actual = HFMining.PORTAL.func_176221_a(dim.func_180495_p(spawn), (IBlockAccess)dim, spawn);
        if (actual.func_177230_c() == HFMining.PORTAL) {
            Random rand = dim.field_73012_v;
            for (int i = 0; i < 512; ++i) {
                BlockPos pos = spawn.func_177982_a(rand.nextInt(51) - 25, 0, rand.nextInt(51) - 25);
                if (!EntityHelper.isSpawnable((World)dim, pos)) continue;
                return pos;
            }
        }
        return MiningHelper.modifySpawnAndEntityRotation((WorldServer)dim, (BlockPos)spawn, (Entity)entity);
    }

    void onTeleportToMine(World world, int mineID) {
        if (!this.generated.contains(mineID)) {
            Object entity = NPCHelper.getEntityForNPC(world, (NPC)HFNPCs.MINER);
            BlockPos pos = this.modifyNPCPosition((WorldServer)world, this.getSpawnCoordinateForMine(mineID, 1), (Entity)entity);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            entity.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Blocks.field_150478_aa));
            entity.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Items.field_151035_b));
            boolean foundTorch = false;
            boolean foundChest = false;
            boolean foundSign = false;
            for (int i = 0; i < 128; ++i) {
                BlockPos torch = pos.func_177982_a(world.field_73012_v.nextInt(7) - 3, 0, world.field_73012_v.nextInt(7));
                if (torch.equals((Object)pos)) continue;
                if (!foundTorch && EntityHelper.isSpawnable(world, torch)) {
                    world.func_180501_a(torch, Blocks.field_150478_aa.func_176223_P(), 3);
                    foundTorch = true;
                } else if (!foundChest && EntityHelper.isSpawnable(world, torch)) {
                    EnumFacing facing = EnumFacing.field_176754_o[world.field_73012_v.nextInt(EnumFacing.field_176754_o.length)];
                    if (!world.func_175623_d(torch.func_177974_f())) {
                        facing = EnumFacing.WEST;
                    } else if (!world.func_175623_d(torch.func_177976_e())) {
                        facing = EnumFacing.EAST;
                    } else if (!world.func_175623_d(torch.func_177978_c())) {
                        facing = EnumFacing.SOUTH;
                    } else if (!world.func_175623_d(torch.func_177968_d())) {
                        facing = EnumFacing.NORTH;
                    }
                    world.func_175656_a(torch, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing));
                    TileEntity chest = world.func_175625_s(torch);
                    if (chest instanceof TileEntityChest) {
                        ((TileEntityChest)chest).func_189404_a(LootStrings.MINING_CHEST, world.field_73012_v.nextLong());
                    }
                    foundChest = true;
                } else if (!foundSign && EntityHelper.isSpawnable(world, torch)) {
                    world.func_175656_a(torch, Blocks.field_150472_an.func_176223_P().func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(16))));
                    TileEntity tile = world.func_175625_s(torch);
                    if (tile instanceof TileEntitySign) {
                        TileEntitySign sign = (TileEntitySign)tile;
                        sign.field_145915_a[0] = new TextComponentTranslation("harvestfestival.shop.miner", new Object[0]);
                        sign.field_145915_a[1] = new TextComponentTranslation("harvestfestival.shop.miner.sign1", new Object[0]);
                        sign.field_145915_a[2] = new TextComponentTranslation("harvestfestival.shop.miner.sign2", new Object[0]);
                        sign.field_145915_a[3] = new TextComponentTranslation("harvestfestival.shop.miner.sign3", new Object[0]);
                        sign.func_70296_d();
                        IBlockState state = world.func_180495_p(sign.func_174877_v());
                        world.func_184138_a(sign.func_174877_v(), state, state, 3);
                    }
                    foundSign = true;
                }
                if (foundChest && foundTorch && foundSign) break;
            }
            ((EntityNPC)((Object)entity)).resetSpawnHome();
            world.func_72838_d(entity);
            this.generated.add(mineID);
        }
        this.func_76185_a();
    }

    static boolean areCoordinatesGenerated(World world, int mineID, int floor) {
        return HFTrackers.getMineManager(world).getCoordinateMap(mineID).containsKey(floor);
    }

    BlockPos getSpawnCoordinateForMine(int mineID, int floor) {
        BlockPos ret = (BlockPos)this.getCoordinateMap(mineID).get(floor);
        if (ret == null) {
            return new BlockPos(0, 254, mineID * 10 * 16);
        }
        return ret;
    }

    private TIntObjectMap<BlockPos> getCoordinateMap(int mineID) {
        TIntObjectMap map = (TIntObjectMap)this.portalCoordinates.get(mineID);
        if (map == null) {
            map = new TIntObjectHashMap();
            this.portalCoordinates.put(mineID, (Object)map);
        }
        return map;
    }

    void setSpawnForMine(int mineID, int floor, int x, int y, int z) {
        this.getCoordinateMap(mineID).putIfAbsent(floor, (Object)new BlockPos(x, y, z));
        this.func_76185_a();
    }

    static TIntObjectMap<IBlockState[][]> getStateMap(int mapIndex) {
        return (TIntObjectMap)generation.get(mapIndex);
    }

    static void putStateMap(int mapIndex, TIntObjectMap<IBlockState[][]> map) {
        generation.put(mapIndex, map);
    }

    static boolean containsStateKey(int mapIndex) {
        return generation.containsKey(mapIndex);
    }

    static boolean containsCoordinatesKey(int mapIndex) {
        return coordinates.containsKey(mapIndex);
    }

    static void putCoordinates(int mapIndex, int[] coordinates) {
        MineManager.coordinates.put(mapIndex, (Object)coordinates);
    }

    static int getCoordinates(int mapIndex, int position) {
        return ((int[])coordinates.get(mapIndex))[position];
    }
}

