/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.data;

import java.util.ArrayList;
import java.util.HashSet;
import joshie.harvest.blocks.HFBlocks;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.mining.MineTrackerServer;
import joshie.harvest.mining.data.Mine;
import joshie.harvest.mining.data.MineAir;
import joshie.harvest.mining.data.MineBlock;
import joshie.harvest.mining.data.MineData;
import joshie.harvest.mining.data.MineFloor;
import joshie.harvest.mining.data.MineWall;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MineLevel {
    private HashSet<MineBlock> blocks = new HashSet();
    private boolean isCavedIn;
    private int number;

    public MineLevel() {
    }

    public MineLevel(int number) {
        this.number = number;
    }

    public void newDay() {
        if (this.isCavedIn) {
            return;
        }
        for (MineBlock block : this.blocks) {
            block.newDay(this.number);
        }
    }

    public boolean isCavedIn() {
        return this.isCavedIn;
    }

    public int get() {
        return this.number;
    }

    public void complete(World world, BlockPos pos, Mine mine, ArrayList<PlaceableBlock> list) {
        for (PlaceableBlock block : list) {
            MineBlock location = null;
            if (block.getBlock() == Blocks.field_150350_a) {
                location = new MineAir(world.field_73011_w.getDimension(), pos);
            } else if (block.getBlock() == HFBlocks.DIRT) {
                location = new MineFloor(world.field_73011_w.getDimension(), pos);
            } else if (block.getBlock() == HFBlocks.STONE) {
                location = new MineWall(world.field_73011_w.getDimension(), pos);
            }
            this.blocks.add(location);
            MineTrackerServer.map.put(location, new MineData(mine, this));
        }
    }

    public void destroy() {
        this.isCavedIn = true;
        for (MineBlock block : this.blocks) {
            WorldServer world = DimensionManager.getWorld((int)block.dimension);
            if (world.field_73012_v.nextInt(64) == 0) {
                world.func_175656_a(block.position, Blocks.field_150347_e.func_176223_P());
                continue;
            }
            world.func_175656_a(block.position, Blocks.field_150351_n.func_176223_P());
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.isCavedIn = nbt.func_74767_n("IsCavedIn");
        this.number = nbt.func_74762_e("Number");
        NBTTagList block = nbt.func_150295_c("Blocks", 10);
        for (int i = 0; i < block.func_74745_c(); ++i) {
            NBTTagCompound tag = block.func_150305_b(i);
            String type = tag.func_74779_i("BlockType");
            MineBlock b = null;
            if (type.equals("air")) {
                b = new MineAir();
                b.readFromNBT(tag);
            } else if (type.equals("wall")) {
                b = new MineWall();
                b.readFromNBT(tag);
            } else if (type.equals("floor")) {
                b = new MineFloor();
                b.readFromNBT(tag);
            }
            this.blocks.add(b);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("IsCavedIn", this.isCavedIn);
        nbt.func_74768_a("Number", this.number);
        NBTTagList block = new NBTTagList();
        for (MineBlock b : this.blocks) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("BlockType", b.getType());
            b.writeToNBT(tag);
            block.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Blocks", (NBTBase)block);
    }
}

