/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.data;

import joshie.harvest.mining.MineTrackerServer;
import joshie.harvest.mining.data.Mine;
import joshie.harvest.mining.data.MineLevel;
import net.minecraft.nbt.NBTTagCompound;

public class MineData {
    private Mine mine;
    private MineLevel level;

    public MineData() {
    }

    public MineData(String name) {
        this.mine = new Mine(name);
        MineTrackerServer.mines.add(this.mine);
        this.level = null;
    }

    public MineData(Mine mine, MineLevel level) {
        this.mine = mine;
        this.level = level;
    }

    public Mine getMine() {
        return this.mine;
    }

    public MineLevel getLevel() {
        return this.level;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        String name = nbt.func_74779_i("MineName");
        int level = nbt.func_74762_e("Level");
        for (Mine mine : MineTrackerServer.mines) {
            if (!mine.getName().equals(name)) continue;
            this.mine = mine;
            if (!nbt.func_74764_b("Level")) break;
            this.level = this.mine.getLevel(level);
            break;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("MineName", this.mine.getName());
        if (this.level != null) {
            nbt.func_74768_a("Level", this.level.get());
        }
    }
}

