/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.data;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.mining.data.MineLevel;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Mine {
    private List<MineLevel> levels = new ArrayList<MineLevel>();
    private String name;

    public String getName() {
        return this.name;
    }

    public Mine() {
    }

    public Mine(String name) {
        this.name = name;
    }

    public void newDay() {
        for (MineLevel level : this.levels) {
            level.newDay();
        }
    }

    public MineLevel getLevel(int level) {
        return this.levels.get(level);
    }

    public int getLevels() {
        return this.levels.size();
    }

    public int addLevel() {
        for (MineLevel level : this.levels) {
            if (!level.isCavedIn()) continue;
            return level.get();
        }
        this.levels.add(new MineLevel(this.levels.size()));
        return this.levels.size() - 1;
    }

    public void complete(World world, BlockPos pos, ArrayList<PlaceableBlock> blocks) {
        this.levels.get(this.levels.size() - 1).complete(world, pos, this, blocks);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("MineName");
        NBTTagList level = nbt.func_150295_c("Levels", 10);
        for (int i = 0; i < level.func_74745_c(); ++i) {
            NBTTagCompound tag = level.func_150305_b(i);
            MineLevel l = new MineLevel();
            l.readFromNBT(tag);
            this.levels.add(l);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("MineName", this.name);
        NBTTagList level = new NBTTagList();
        for (MineLevel l : this.levels) {
            NBTTagCompound tag = new NBTTagCompound();
            l.writeToNBT(tag);
            level.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Levels", (NBTBase)level);
    }
}

