/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnumCube;
import joshie.harvest.core.util.Text;
import joshie.harvest.mining.HFMining;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStone
extends BlockHFEnumCube<BlockStone, Type> {
    public BlockStone() {
        super(Material.field_151576_e, Type.class, HFTab.MINING);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getEnumFromState(state) == Type.REAL ? -1.0f : 4.0f;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.getEnumFromState(state) != Type.REAL;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.getEnumFromState(world.func_180495_p(pos)) == Type.REAL ? 6.0E7f : 14.0f;
    }

    @Override
    public int getToolLevel(Type type) {
        return 2;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.getEnumFromState(world.func_180495_p(pos)) != Type.REAL) {
            ret.add(new ItemStack((Block)HFMining.STONE, 1, 1));
        }
        return ret;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        String unlocalized = this.func_149739_a();
        String name = stack.func_77952_i() != 0 ? "decorative" : stack.func_77973_b().func_77667_c(stack);
        return Text.localizeFully(unlocalized + "." + name);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        int adjusted = Math.max(0, Math.min(Type.values().length, stack.func_77952_i()));
        Type type = Type.values()[adjusted];
        if (type.isFake()) {
            list.add(TextFormatting.YELLOW + Text.translate("tooltip.cosmetic"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < ((Type[])this.values).length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("harvestfestival", "mine/mine_wall_" + ((Type)((Object)this.getEnumFromMeta(i))).func_176610_l()), "inventory"));
        }
    }

    public static enum Type implements IStringSerializable
    {
        REAL,
        DECORATIVE_BLANK,
        DECORATIVE_PURPLE,
        DECORATIVE_SILVER,
        DECORATIVE_GREEN,
        DECORATIVE_BLUE,
        DECORATIVE_RED;


        public boolean isFake() {
            return this != REAL;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

